/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;

public class ConfigUtils {
    private static final Gson serializer = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();

    public static void writeConfig(Path path, Object source) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            serializer.toJson(source, (Appendable)writer);
            ((Writer)writer).flush();
        }
    }

    @Nullable
    public static <T> T readConfig(Path path, Type target) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Object object = serializer.fromJson((Reader)reader, target);
            return (T)object;
        }
    }
}

