/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.BlazeNucleus;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class BlazeNucleusEvents {
    @SubscribeEvent
    public static void setFireEntity(LivingDamageEvent.Pre event) {
        BlazeNucleus.Stats config = (BlazeNucleus.Stats)BlazeNucleus.INSTANCE.getTrinketConfig();
        DamageSource source = event.getSource();
        Entity src = source.getEntity();
        if (!config.isEnable) {
            return;
        }
        if (!(src instanceof Player)) {
            return;
        }
        Player attacker = (Player)src;
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)attacker);
        if (accessories == null) {
            return;
        }
        List stack = accessories.getEquipped(ModItems.BLAZE_NUCLEUS.get());
        if (!stack.isEmpty()) {
            LivingEntity target = event.getEntity();
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = target;
                livingTarget.setRemainingFireTicks(config.setEnemyInFireTicks);
            }
            attacker.clearFire();
        }
    }

    @SubscribeEvent
    public static void blazeNucleusImmune(LivingDamageEvent.Pre event) {
        Player player;
        BlazeNucleus.Stats config = (BlazeNucleus.Stats)BlazeNucleus.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).isSpectator()) {
            return;
        }
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
        if (accessories == null) {
            return;
        }
        List stack = accessories.getEquipped(ModItems.BLAZE_NUCLEUS.get());
        if (!stack.isEmpty() && config.fireDamageReductionPercentage < 100.0f && event.getSource().is(DamageTypeTags.IS_FIRE)) {
            event.setNewDamage(event.getOriginalDamage() * (1.0f - config.fireDamageReductionPercentage / 100.0f));
        }
    }
}

