/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.FourLeafClover;
import io.wispforest.accessories.api.AccessoriesCapability;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class FourLeafCloverEvents {
    @SubscribeEvent
    public static void entityKilled(LivingDeathEvent event) {
        FourLeafClover.Stats config = (FourLeafClover.Stats)FourLeafClover.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.level().isClientSide) {
                AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
                if (accessories == null) {
                    return;
                }
                List stack = accessories.getEquipped(ModItems.FOUR_LEAF_CLOVER.get());
                if (!stack.isEmpty()) {
                    Level level = player.level();
                    LootTable loot = level.getServer().reloadableRegistries().getLootTable((ResourceKey)event.getEntity().getType().getDefaultLootTable().get());
                    LootParams context = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)event.getEntity().blockPosition())).withParameter(LootContextParams.THIS_ENTITY, (Object)event.getEntity()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)player.damageSources().playerAttack(player)).create(LootContextParamSets.ENTITY);
                    ObjectArrayList drops = loot.getRandomItems(context);
                    for (int i = 1; i < config.extraLoots; ++i) {
                        for (ItemStack drop : drops) {
                            ItemEntity itementity = new ItemEntity(level, event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), drop);
                            itementity.setDefaultPickUpDelay();
                            itementity.setDeltaMovement(itementity.getDeltaMovement().add((double)((level.random.nextFloat() - level.random.nextFloat()) * 0.1f), (double)(level.random.nextFloat() * 0.05f), (double)((level.random.nextFloat() - level.random.nextFloat()) * 0.1f)));
                            level.addFreshEntity((Entity)itementity);
                        }
                    }
                }
            }
        }
    }
}

