/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.IceCube;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class IceCubeEvents {
    @SubscribeEvent
    public static void applySlowEffect(LivingDamageEvent.Post event) {
        IceCube.Stats config = (IceCube.Stats)IceCube.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getSource().getEntity() instanceof Player)) {
            return;
        }
        DamageSource source = event.getSource();
        Entity src = source.getEntity();
        if (src instanceof Player) {
            Player player = (Player)src;
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.ICE_CUBE.get());
            if (!stack.isEmpty()) {
                MobEffectInstance effectinstance = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, config.slownessTime, config.slownessLevel);
                LivingEntity potionGo = event.getEntity();
                potionGo.addEffect(effectinstance);
            }
        }
    }

    @SubscribeEvent
    public static void placeFrostedIce(PlayerTickEvent.Pre event) {
        IceCube.Stats config = (IceCube.Stats)IceCube.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = event.getEntity();
        BlockPos pos = player.blockPosition();
        Level world = player.level();
        if (player instanceof ServerPlayer && !player.isSpectator()) {
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.ICE_CUBE.get());
            if (!stack.isEmpty() && !player.level().isClientSide) {
                BlockState block = Blocks.ICE.defaultBlockState();
                ((ServerLevel)player.getCommandSenderWorld()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), player.getX(), player.getY(), player.getZ(), 1, 0.5, 1.0, 0.5, 0.1);
                if (player.onGround()) {
                    BlockState blockstate = Blocks.FROSTED_ICE.defaultBlockState();
                    float f = Math.min(16, 2 + config.frostWalkerLevel);
                    BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
                    for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset((int)(-f), -1, (int)(-f)), (BlockPos)pos.offset((int)f, -1, (int)f))) {
                        boolean isFull;
                        if (!blockpos.closerToCenterThan((Position)player.position(), (double)f)) continue;
                        blockpos$mutable.set(blockpos.getX(), blockpos.getY() + 1, blockpos.getZ());
                        BlockState blockstate1 = world.getBlockState((BlockPos)blockpos$mutable);
                        if (!blockstate1.isAir()) continue;
                        BlockState blockstate2 = world.getBlockState(blockpos);
                        boolean bl = isFull = blockstate2.getBlock() == Blocks.WATER && (Integer)blockstate2.getValue((Property)LiquidBlock.LEVEL) == 0;
                        if (blockstate2 != FrostedIceBlock.meltsInto() || !isFull || !blockstate.canSurvive((LevelReader)world, blockpos) || !world.isUnobstructed(blockstate, blockpos, CollisionContext.empty()) || EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)blockpos), (Direction)Direction.UP)) continue;
                        world.setBlockAndUpdate(blockpos, blockstate);
                        world.scheduleTick(blockpos, Blocks.FROSTED_ICE, Mth.nextInt((RandomSource)player.getRandom(), (int)60, (int)120));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void negateFreezeDamage(LivingDamageEvent.Pre event) {
        Player player;
        IceCube.Stats config = (IceCube.Stats)IceCube.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).isSpectator() && event.getEntity() == player) {
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.ICE_CUBE.get());
            if (!stack.isEmpty() && config.inmuneToFreezing && event.getSource().is(DamageTypeTags.IS_FREEZING)) {
                event.setNewDamage(0.0f);
            }
        }
    }
}

