/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModDataComponents;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.RageMind;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class RageMindEvents {
    @SubscribeEvent
    public static void getEntity(LivingDamageEvent.Pre event) {
        RageMind.Stats config = (RageMind.Stats)RageMind.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Entity entity;
            Player player = (Player)livingEntity;
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.RAGE_MIND.get());
            if (!stack.isEmpty() && (entity = event.getSource().getEntity()) instanceof LivingEntity) {
                ((SlotEntryReference)stack.getFirst()).stack().set(ModDataComponents.RAGE_MIND_REVENGE_TARGET.get(), (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString());
            }
        }
    }

    @SubscribeEvent
    public static void dealDamage(LivingDamageEvent.Pre event) {
        RageMind.Stats config = (RageMind.Stats)RageMind.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(event.getSource().getEntity() instanceof Player)) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.RAGE_MIND.get());
            if (!stack.isEmpty() && ((SlotEntryReference)stack.getFirst()).stack().get(ModDataComponents.RAGE_MIND_REVENGE_TARGET.get()) != null) {
                String entityString = (String)((SlotEntryReference)stack.getFirst()).stack().get(ModDataComponents.RAGE_MIND_REVENGE_TARGET.get());
                ResourceLocation resourceLocation = ResourceLocation.parse((String)entityString);
                EntityType entityType = (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation).get()).value();
                Entity entity2 = entityType.create(player.level(), EntitySpawnReason.SPAWN_ITEM_USE);
                if (entity2 == null) {
                    return;
                }
                Class<?> classEntity = entity2.getClass();
                if (event.getEntity() == null) {
                    return;
                }
                if (event.getEntity().getClass() == classEntity) {
                    event.setNewDamage(event.getOriginalDamage() * config.damageMultiplier);
                }
            }
        }
    }
}

