/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.SleepingPills;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class SleepingPillsEvents {
    @SubscribeEvent
    public static void preventSleep(CanPlayerSleepEvent event) {
        SleepingPills.Stats config = (SleepingPills.Stats)SleepingPills.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        ServerPlayer player = event.getEntity();
        if (!player.isSpectator()) {
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.SLEEPING_PILLS.get());
            if (!stack.isEmpty() && config.bedDisabled) {
                event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
            }
        }
    }
}

