/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class DragonsEye
extends TrinketItem<Stats> {
    public static DragonsEye INSTANCE;

    public DragonsEye() {
        super(new TrinketData(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"dragons_eye"))), null, Stats.class));
        INSTANCE = this;
    }

    public boolean canEquipFromUse(ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        reference.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.isDisabled").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.dragons_eye_lore").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.dragons_eye_1", (Object[])new Object[]{Float.valueOf(config.radius)}).withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.hold_shift"));
                tooltip.add((Component)Component.translatable((String)(String.valueOf(ChatFormatting.GRAY) + "Suggested By: emu")));
            }
        }
    }

    public void tick(ItemStack stack, SlotReference reference) {
        LivingEntity livingEntity;
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable || !((livingEntity = reference.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (config.blindness) {
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 120, 1));
        }
        Level world = player.level();
        List entities = world.getEntitiesOfClass(Mob.class, player.getBoundingBox().inflate((double)config.radius));
        Scoreboard scoreboard = player.getScoreboard();
        PlayerTeam playerTeam = scoreboard.getPlayerTeam("dragonsEyeTargets");
        if (playerTeam == null) {
            playerTeam = scoreboard.addPlayerTeam("dragonsEyeTargets");
            playerTeam.setColor(ChatFormatting.LIGHT_PURPLE);
        }
        for (Mob entity : entities) {
            if (!entity.shouldDespawnInPeaceful() && entity.getSoundSource() != SoundSource.HOSTILE && !entity.isAggressive()) continue;
            entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 20, 30));
            scoreboard.addPlayerToTeam(entity.getStringUUID(), playerTeam);
        }
    }

    public static class Stats
    extends TrinketsStats {
        public float radius = 20.0f;
        public boolean blindness = true;
        public boolean isEnable = true;
    }
}

