/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModDataComponents;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class RageMind
extends TrinketItem<Stats> {
    public static RageMind INSTANCE;

    public RageMind() {
        super(new TrinketData(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"rage_mind"))), null, Stats.class));
        INSTANCE = this;
    }

    public void tick(ItemStack stack, SlotReference reference) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = reference.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (stack.get(ModDataComponents.RAGE_MIND_REVENGE_TARGET.get()) != null) {
            String entityString = (String)stack.get(ModDataComponents.RAGE_MIND_REVENGE_TARGET.get());
            ResourceLocation resourceLocation = ResourceLocation.parse((String)entityString);
            EntityType entityType = (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation).get()).value();
            Entity entity = entityType.create(player.level(), EntitySpawnReason.SPAWN_ITEM_USE);
            if (entity == null) {
                return;
            }
            Class<?> classEntity = entity.getClass();
            AABB targetBox = new AABB(player.position(), player.position()).inflate((double)config.range);
            List foundTarget = player.level().getEntitiesOfClass(classEntity, targetBox);
            if (!foundTarget.isEmpty()) {
                for (Entity revengeTarget : foundTarget) {
                    PlayerTeam playerteam;
                    if (!(revengeTarget instanceof LivingEntity)) continue;
                    LivingEntity livingRevengeTarget = (LivingEntity)revengeTarget;
                    MobEffectInstance effectinstance = new MobEffectInstance(MobEffects.GLOWING, 20, 20);
                    Scoreboard scoreboard = player.getScoreboard();
                    if (!scoreboard.getTeamNames().contains("rageMindRevengeTargets")) {
                        scoreboard.addPlayerTeam("rageMindRevengeTargets");
                    }
                    if ((playerteam = player.level().getScoreboard().getPlayerTeam("rageMindRevengeTargets")) == null) {
                        return;
                    }
                    scoreboard.addPlayerToTeam(livingRevengeTarget.getStringUUID(), playerteam);
                    playerteam.setColor(ChatFormatting.RED);
                    livingRevengeTarget.addEffect(effectinstance);
                }
            }
        }
    }

    public boolean canEquipFromUse(ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        reference.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.isDisabled").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.rage_mind_lore").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.rage_mind_1").withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.rage_mind_2", (Object[])new Object[]{Float.valueOf(config.damageMultiplier)}).withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public float damageMultiplier = 1.5f;
        public float range = 50.0f;
        public boolean isEnable = true;
    }
}

