/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.AABB;

public class Tick
extends TrinketItem<Stats> {
    public static Tick INSTANCE;

    public Tick() {
        super(new TrinketData(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"tick"))), null, Stats.class));
        INSTANCE = this;
    }

    public static boolean isValidTarget(LivingEntity ent) {
        return ent.getType() != EntityType.PLAYER && !ent.isInvulnerable();
    }

    public boolean canEquipFromUse(ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        reference.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public boolean canUnequip(ItemStack stack, SlotReference reference) {
        LivingEntity livingEntity = reference.entity();
        Player player = (Player)livingEntity;
        return livingEntity.isOnFire() || player.getAbilities().instabuild;
    }

    public void tick(ItemStack stack, SlotReference reference) {
        ServerPlayer player;
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = reference.entity();
        if (!(livingEntity instanceof ServerPlayer) || (player = (ServerPlayer)livingEntity).isSpectator()) {
            return;
        }
        if (!stack.isEmpty()) {
            AABB targetBox = new AABB(player.position(), player.position()).inflate((double)config.rangeToActivate);
            List foundTarget = player.level().getEntitiesOfClass(LivingEntity.class, targetBox, Tick::isValidTarget);
            if (!foundTarget.isEmpty()) {
                for (LivingEntity livingEntity2 : foundTarget) {
                    if (livingEntity2.getMaxHealth() > 50.0f && livingEntity2.getHealth() > livingEntity2.getMaxHealth() / 2.0f && player.getHealth() >= 5.0f) {
                        livingEntity2.hurt(livingEntity2.damageSources().generic(), livingEntity2.getMaxHealth() * (config.entityDamagePercentage / 100.0f));
                        player.hurt(livingEntity2.damageSources().generic(), player.getMaxHealth() * (config.playerDamagePercentage / 100.0f));
                        continue;
                    }
                    if (!(livingEntity2.getMaxHealth() > 50.0f) || !(livingEntity2.getHealth() > livingEntity2.getMaxHealth() / 2.0f) || player.getFoodData().getFoodLevel() < 5) continue;
                    livingEntity2.hurt(livingEntity2.damageSources().generic(), livingEntity2.getMaxHealth() * (config.entityDamagePercentage / 100.0f));
                    player.causeFoodExhaustion((float)player.getFoodData().getFoodLevel() * (config.playerHungerPercentage / 100.0f));
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.isDisabled").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.tick_lore").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.tick_1", (Object[])new Object[]{config.entityDamagePercentage + "%"}).withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.tick_2").withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.tick_3").withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.tick_4").withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public float rangeToActivate = 25.0f;
        public float entityDamagePercentage = 1.0f;
        public float playerDamagePercentage = 5.0f;
        public float playerHungerPercentage = 10.0f;
        public boolean isEnable = true;
    }
}

