/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class WhatMagnet
extends TrinketItem<Stats> {
    public static WhatMagnet INSTANCE;

    public WhatMagnet() {
        super(new TrinketData(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"what_magnet"))), null, Stats.class));
        INSTANCE = this;
    }

    public boolean canEquipFromUse(ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        reference.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void tick(ItemStack stack, SlotReference reference) {
        LivingEntity livingEntity = reference.entity();
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        Level world = livingEntity.level();
        Random random = new Random();
        float rx = random.nextFloat() * 5.0f - 2.5f;
        float rz = random.nextFloat() * 5.0f - 2.5f;
        List entitiesOfClass = world.getEntitiesOfClass(LivingEntity.class, livingEntity.getBoundingBox().inflate((double)config.range));
        for (LivingEntity entity : entitiesOfClass) {
            if (world.isClientSide) continue;
            entity.setPos(livingEntity.getX() + (double)rx, livingEntity.getY(), livingEntity.getZ() + (double)rz);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.isDisabled").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.what_magnet_lore").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.what_magnet_1", (Object[])new Object[]{Float.valueOf(config.range)}).withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public float range = 25.0f;
        public boolean isEnable = true;
    }
}

