/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.SparkType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public record SparkProvider(List<BlockStateHolder> states, Optional<Options> options) {
    public static final Codec<SparkProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(BlockStateHolder.CODEC, (int)1, (int)Integer.MAX_VALUE).fieldOf("states").forGetter(SparkProvider::states), (App)Options.CODEC.optionalFieldOf("options").forGetter(SparkProvider::options)).apply((Applicative)instance, SparkProvider::new));

    public record BlockStateHolder(Block block, Map<Property<?>, Comparable<?>> properties) {
        public static final Codec<BlockStateHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("name").forGetter(BlockStateHolder::block), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties").forGetter(holder -> Optional.of(holder.properties.entrySet().stream().collect(Collectors.toMap(entry -> ((Property)entry.getKey()).getName(), entry -> ((Comparable)entry.getValue()).toString(), (s1, s2) -> s1))))).apply((Applicative)instance, (block, properties) -> {
            StateDefinition definition = block.getStateDefinition();
            return new BlockStateHolder((Block)block, ((Map)properties.orElse(new HashMap())).entrySet().stream().map(entry -> BlockStateHolder.convertToProperties(entry, definition.getProperty((String)entry.getKey()))).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (c1, c2) -> c1)));
        }));

        private static <T extends Comparable<T>> Map.Entry<Property<T>, Comparable<T>> convertToProperties(Map.Entry<String, String> entry, Property<T> property) {
            String propertyName = entry.getKey();
            String valueName = entry.getValue();
            if (property != null) {
                Optional value = property.getValue(valueName);
                if (value.isPresent()) {
                    return Map.entry(property, (Comparable)value.get());
                }
                SubtleEffects.LOGGER.error("Unknown value '{}' for blockstate property '{}' in spark provider. Possible values for property {}", new Object[]{valueName, propertyName, property.getPossibleValues()});
                return null;
            }
            SubtleEffects.LOGGER.error("Unknown blockstate property '{}' for spark provider", (Object)propertyName);
            return null;
        }

        public boolean matches(BlockState state) {
            if (state != null && state.is(this.block)) {
                for (Map.Entry<Property<?>, Comparable<?>> entry : this.properties.entrySet()) {
                    if (Objects.equals(state.getValue(entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public record Options(PresetType preset, Optional<SparkType> sparkType, Optional<Box> box, Optional<Integer> count, Optional<Vec3> velocity, Optional<List<Integer>> colors) {
        public static final Codec<Options> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PresetType.CODEC.fieldOf("preset").forGetter(Options::preset), (App)SparkType.CODEC.optionalFieldOf("spark").forGetter(Options::sparkType), (App)Box.CODEC.optionalFieldOf("box").forGetter(Options::box), (App)Codec.INT.optionalFieldOf("count").forGetter(Options::count), (App)Vec3.CODEC.optionalFieldOf("velocity").forGetter(Options::velocity), (App)Codec.withAlternative((Codec)Codec.list((Codec)Codec.INT), (Codec)Codec.STRING, string -> {
            if (string.equals("soul")) {
                return SparkParticle.SOUL_COLORS;
            }
            if (string.equals("default")) {
                return SparkParticle.DEFAULT_COLORS;
            }
            SubtleEffects.LOGGER.error("Spark color must be an integer array or string of either 'soul' or 'default'");
            return null;
        }).optionalFieldOf("colors").forGetter(Options::colors)).apply((Applicative)instance, Options::new));
    }

    public static enum PresetType implements StringRepresentable
    {
        CUSTOM("custom"),
        CAMPFIRE("campfire"),
        FIRE("fire"),
        TORCH("torch"),
        WALL_TORCH("wall_torch"),
        CANDLE("candle"),
        LANTERN("lantern"),
        FURNACE("furnace");

        public static final Codec<PresetType> CODEC;
        private final String name;

        private PresetType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(PresetType::values);
        }
    }
}

