/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.EntityAccessRenderState;
import java.util.Optional;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin<T extends Entity, S extends EntityRenderState> {
    @Inject(method={"extractRenderState"}, at={@At(value="TAIL")})
    private void extractRenderState(T entity, S renderState, float partialTicks, CallbackInfo ci) {
        ((EntityAccessRenderState)renderState).subtleEffects$setEntity((Entity)entity);
    }

    @WrapOperation(method={"renderNameTag"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V")})
    private void translate(PoseStack poseStack, double x, double y, double z, Operation<Void> original, EntityRenderState renderState, @Local Vec3 nameTagPos) {
        LivingEntity livingEntity;
        if (!ModConfigs.ENTITIES.sleeping.adjustNameTagWhenSleeping) {
            original.call(new Object[]{poseStack, x, y, z});
            return;
        }
        Entity entity = ((EntityAccessRenderState)renderState).subtleEffects$getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isSleeping()) {
            BlockState state;
            Level level = entity.level();
            Optional pos = livingEntity.getSleepingPos();
            if (pos.isPresent() && (state = level.getBlockState((BlockPos)pos.get())).hasProperty((Property)BedBlock.OCCUPIED) && ((Boolean)state.getValue((Property)BedBlock.OCCUPIED)).booleanValue()) {
                Direction facing = (Direction)state.getValue((Property)BedBlock.FACING);
                switch (facing) {
                    case NORTH: {
                        poseStack.translate(z, x, -y);
                        break;
                    }
                    case SOUTH: {
                        poseStack.translate(z, x, y);
                        break;
                    }
                    case EAST: {
                        poseStack.translate(y, z, x);
                        break;
                    }
                    case WEST: {
                        poseStack.translate(-y, z, x);
                        break;
                    }
                    default: {
                        original.call(new Object[]{poseStack, x, y, z});
                    }
                }
                return;
            }
        }
        original.call(new Object[]{poseStack, x, y, z});
    }
}

