/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class SnowParticle
extends TextureSheetParticle {
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    protected SnowParticle(ClientLevel level, SpriteSet sprites, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.lifetime = 20;
        this.quadSize = 0.1f;
        this.setSize(0.1f, 0.1f);
        this.pickSprite(sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.pos.set(this.x, this.y, this.z);
        this.oRoll = this.roll;
        this.roll = this.oRoll + 0.1f;
        if (this.onGround || this.level.getFluidState((BlockPos)this.pos).is((Fluid)Fluids.WATER)) {
            this.remove();
        }
    }

    public record SnowballTrailProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        private static final float GRAVITY = 0.1f;

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SnowParticle particle = new SnowParticle(level, this.sprites, x, y, z, 0.0, 0.0, 0.0);
            particle.gravity = 0.1f;
            particle.xd = 0.0;
            particle.yd = -0.1f;
            particle.zd = 0.0;
            return particle;
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SnowParticle particle = new SnowParticle(level, this.sprites, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.gravity = 1.0f;
            return particle;
        }
    }
}

