/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle.provider;

import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.util.ParticleAccessor;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.material.Fluids;

public class ResinDripParticleProviders {
    private static void setProperties(DripParticle particle, SpriteSet sprites, @Nullable Float gravity, @Nullable Integer lifeTime) {
        if (gravity != null) {
            ((ParticleAccessor)particle).setGravity(gravity.floatValue());
        }
        if (lifeTime != null) {
            particle.setLifetime(lifeTime.intValue());
        }
        particle.pickSprite(sprites);
        particle.setColor(0.925f, 0.447f, 0.078f);
    }

    public record LandingResinDropProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DripParticle.DripLandParticle particle = new DripParticle.DripLandParticle(level, x, y, z, Fluids.EMPTY);
            ResinDripParticleProviders.setProperties((DripParticle)particle, this.sprites, null, (int)(28.0 / (Math.random() * 0.8 + 0.2)));
            return particle;
        }
    }

    public record FallingResinDropProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DripParticle.FallAndLandParticle particle = new DripParticle.FallAndLandParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)ModParticles.LANDING_RESIN.get());
            ResinDripParticleProviders.setProperties((DripParticle)particle, this.sprites, Float.valueOf(0.01f), null);
            return particle;
        }
    }

    public record DrippingResinDropProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DripParticle.DripHangParticle particle = new DripParticle.DripHangParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)ModParticles.FALLING_RESIN.get());
            ResinDripParticleProviders.setProperties((DripParticle)particle, this.sprites, Float.valueOf(((ParticleAccessor)particle).getGravity() * 0.01f), 100);
            return particle;
        }
    }
}

