/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DrowningTicker
extends Ticker<LivingEntity> {
    public DrowningTicker(LivingEntity entity) {
        super(entity);
    }

    @Override
    public void tick() {
        if (((LivingEntity)this.entity).isSpectator() || ((LivingEntity)this.entity).getAirSupply() <= 0) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Entity entity = this.entity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.isCreative()) {
                return;
            }
            if (player.equals((Object)minecraft.player) && !ModConfigs.ENTITIES.humanoids.drowningBubbles.test(minecraft)) {
                return;
            }
        }
        if (this.random.nextInt(((Integer)ModConfigs.ENTITIES.humanoids.drowningBubblesDensity.get()).intValue()) == 0 && ((LivingEntity)this.entity).isUnderWater()) {
            ParticleSpawnUtil.spawnEntityFaceParticle((ParticleOptions)ParticleTypes.BUBBLE, (LivingEntity)this.entity, this.level, new Vec3(0.0, -0.1, 0.0), Vec3.ZERO, minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(false));
        }
    }
}

