/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.SereneSeasonsCompat;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public class FrostyBreathTicker
extends Ticker<LivingEntity> {
    private int delayTimer = 0;
    private int breatheTimer = 0;
    private int breatheOutTimer = 0;
    private final int startDelay = this.random.nextInt(40);

    public FrostyBreathTicker(LivingEntity entity) {
        super(entity);
    }

    @Override
    public void tick() {
        BlockPos pos = ((LivingEntity)this.entity).blockPosition();
        if (((LivingEntity)this.entity).isSpectator()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Entity entity = this.entity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.isCreative()) {
                return;
            }
            if (player.equals((Object)minecraft.player) && !ModConfigs.ENTITIES.humanoids.frostyBreath.displayType.test(minecraft)) {
                return;
            }
        }
        if (this.level.getBrightness(LightLayer.BLOCK, ((LivingEntity)this.entity).blockPosition()) >= 10) {
            return;
        }
        if (((LivingEntity)this.entity).isInWater() || ((LivingEntity)this.entity).isEyeInFluid(FluidTags.LAVA)) {
            return;
        }
        Holder biome = this.level.getBiome(pos);
        if (((Biome)biome.value()).coldEnoughToSnow(pos, this.level.getSeaLevel()) || ModConfigs.ENTITIES.humanoids.frostyBreath.additionalBiomes.contains(biome.unwrapKey().map(ResourceKey::location).orElse(null)) || CompatHelper.IS_SERENE_SEANSONS_LOADED.get().booleanValue() && SereneSeasonsCompat.isColdSeason(this.level)) {
            if (this.delayTimer < this.startDelay) {
                ++this.delayTimer;
                return;
            }
            if (this.breatheTimer >= (Integer)ModConfigs.ENTITIES.humanoids.frostyBreath.waitTime.get()) {
                ParticleSpawnUtil.spawnEntityFaceParticle((ParticleOptions)ModParticles.FROSTY_BREATH.get(), (LivingEntity)this.entity, this.level, this.random, new Vec3(0.0, -0.1, 0.0), new Vec3(0.0, 0.0, Mth.nextDouble((RandomSource)this.random, (double)0.005, (double)0.01)), minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(false));
                if (this.breatheOutTimer >= 7) {
                    this.breatheOutTimer = 0;
                    this.breatheTimer = 0;
                }
                ++this.breatheOutTimer;
            }
            ++this.breatheTimer;
        }
    }
}

