/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.util.MathUtil;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class IronGolemTicker
extends Ticker<IronGolem> {
    private Crackiness.Level oldCrackinessLevel;
    private float oldHealth;

    public IronGolemTicker(IronGolem entity) {
        super(entity);
    }

    @Override
    public void tick() {
        Crackiness.Level crackinessLevel = ((IronGolem)this.entity).getCrackiness();
        if (this.oldCrackinessLevel != crackinessLevel) {
            this.oldCrackinessLevel = crackinessLevel;
            float health = ((IronGolem)this.entity).getHealth();
            if (this.oldHealth != health) {
                if (health < this.oldHealth) {
                    for (int i = 0; i < 20; ++i) {
                        this.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.IRON_INGOT)), ((IronGolem)this.entity).getRandomX(0.5), ((IronGolem)this.entity).getRandomY(), ((IronGolem)this.entity).getRandomZ(0.5), MathUtil.nextNonAbsDouble(this.random) / 10.0, MathUtil.nextNonAbsDouble(this.random) / 10.0, MathUtil.nextNonAbsDouble(this.random) / 10.0);
                    }
                }
                this.oldHealth = health;
            }
        }
    }
}

