/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.tickers.SimpleTicker;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.util.EntityProvider;
import einstein.subtle_effects.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TickerManager {
    private static final List<TickerProvider<?>> REGISTERED_TICKERS = new ArrayList();
    private static final Int2ObjectMap<Int2ObjectMap<Ticker<?>>> TICKERS = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<IntList> REMOVE_QUEUE = new Int2ObjectOpenHashMap();
    public static final int INNER_RANGE = 128;
    public static final int OUTER_RANGE = 144;
    private static int REGISTERED_TICKER_ID = 0;

    public static <T extends Entity> void registerTicker(Predicate<Entity> predicate, Function<T, Ticker<T>> function) {
        REGISTERED_TICKERS.add(new TickerProvider<T>(REGISTERED_TICKER_ID++, predicate, function));
    }

    public static <T extends Entity> void registerSimpleTicker(EntityType<T> type, Supplier<Boolean> isEnabled, EntityProvider<T> provider) {
        TickerManager.registerSimpleTicker(entity -> entity.getType().equals(type) && (Boolean)isEnabled.get() != false, provider);
    }

    public static <T extends Entity> void registerSimpleTicker(Predicate<Entity> predicate, EntityProvider<T> provider) {
        REGISTERED_TICKERS.add(new TickerProvider<Entity>(REGISTERED_TICKER_ID++, predicate, entity -> new SimpleTicker<Entity>((Entity)entity, provider)));
    }

    public static void tickTickers(Level level) {
        TICKERS.forEach((entityId, tickers) -> {
            Entity entity = level.getEntity(entityId.intValue());
            if (entity != null && entity.isAlive()) {
                if (TickerManager.isEntityInRange(entity, 128)) {
                    IntArrayList removeQueue = new IntArrayList();
                    tickers.forEach((arg_0, arg_1) -> TickerManager.lambda$tickTickers$2((IntList)removeQueue, arg_0, arg_1));
                    TickerManager.remove(entityId, (IntCollection)removeQueue);
                    return;
                }
                if (!TickerManager.isEntityInRange(entity, 144)) {
                    TickerManager.remove(entityId, (IntCollection)tickers.keySet());
                }
                return;
            }
            TickerManager.remove(entityId, (IntCollection)tickers.keySet());
        });
        REMOVE_QUEUE.forEach((entityId, tickerIds) -> {
            if (TICKERS.containsKey(entityId.intValue())) {
                Int2ObjectMap tickers = (Int2ObjectMap)TICKERS.get(entityId.intValue());
                tickerIds.forEach(arg_0 -> ((Int2ObjectMap)tickers).remove(arg_0));
                if (tickers.isEmpty()) {
                    TICKERS.remove(entityId.intValue());
                }
            }
        });
        REMOVE_QUEUE.clear();
    }

    private static void remove(int entityId, IntCollection tickerIds) {
        if (tickerIds.isEmpty()) {
            return;
        }
        if (REMOVE_QUEUE.containsKey(entityId)) {
            ((IntList)REMOVE_QUEUE.get(entityId)).addAll(tickerIds);
            return;
        }
        REMOVE_QUEUE.put(entityId, (Object)new IntArrayList(tickerIds));
    }

    public static <T extends Entity> void createTickersForEntity(T entity) {
        if (Minecraft.getInstance().player != null && TickerManager.isEntityInRange(entity, 128)) {
            int entityId = entity.getId();
            Int2ObjectOpenHashMap tickers = TICKERS.containsKey(entityId) ? (Int2ObjectMap)TICKERS.get(entityId) : new Int2ObjectOpenHashMap();
            REGISTERED_TICKERS.forEach(arg_0 -> TickerManager.lambda$createTickersForEntity$5((Int2ObjectMap)tickers, entity, arg_0));
            if (!tickers.isEmpty()) {
                TICKERS.put(entityId, (Object)tickers);
            }
        }
    }

    private static <T extends Entity> boolean isEntityInRange(T entity, int range) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            if (player.is(entity)) {
                return true;
            }
            Vec3 position = entity.position();
            return Util.isChunkLoaded(entity.level(), position.x(), position.z()) && player.position().closerThan((Position)position, (double)range);
        }
        return false;
    }

    public static void clear() {
        TICKERS.clear();
        REMOVE_QUEUE.clear();
    }

    private static /* synthetic */ void lambda$createTickersForEntity$5(Int2ObjectMap tickers, Entity entity, TickerProvider provider) {
        if (!tickers.containsKey(provider.id()) && provider.predicate().test(entity)) {
            tickers.put(provider.id(), provider.function().apply(entity));
        }
    }

    private static /* synthetic */ void lambda$tickTickers$2(IntList removeQueue, Integer tickerId, Ticker ticker) {
        if (ticker.isRemoved()) {
            removeQueue.add(tickerId.intValue());
            return;
        }
        ticker.tick();
    }

    public record TickerProvider<T extends Entity>(int id, Predicate<Entity> predicate, Function<T, Ticker<T>> function) {
    }
}

