/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.mob;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.config.VariantsAndVenturesConfig;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesSoundEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class VerdantEntity
extends AbstractSkeleton {
    public VerdantEntity(EntityType<? extends AbstractSkeleton> entityType, Level world) {
        super(entityType, world);
    }

    protected SoundEvent getAmbientSound() {
        return VariantsAndVenturesSoundEvents.ENTITY_VERDANT_AMBIENT.get();
    }

    public void playAmbientSound() {
        SoundEvent soundEvent = this.getAmbientSound();
        if (soundEvent != null) {
            this.playSound(soundEvent, 0.25f, this.getVoicePitch());
        }
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return VariantsAndVenturesSoundEvents.ENTITY_VERDANT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return VariantsAndVenturesSoundEvents.ENTITY_VERDANT_DEATH.get();
    }

    public SoundEvent getStepSound() {
        return VariantsAndVenturesSoundEvents.ENTITY_VERDANT_STEP.get();
    }

    public void tick() {
        VariantsAndVentures.getConfig();
        if (!VariantsAndVenturesConfig.modMobs.enableVerdant) {
            this.discard();
        }
        super.tick();
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        ItemStack itemStack = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, (Item)Items.BOW));
        ItemStack itemStack2 = this.getProjectile(itemStack);
        AbstractArrow abstractArrow = this.getArrow(itemStack2, velocity, itemStack);
        double d = target.getX() - this.getX();
        double e = target.getY(0.3333333333333333) - abstractArrow.getY();
        double f = target.getZ() - this.getZ();
        double g = Math.sqrt(d * d + f * f);
        Level var15 = this.level();
        if (var15 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var15;
            Projectile.spawnProjectileUsingShoot((Projectile)abstractArrow, (ServerLevel)serverLevel, (ItemStack)itemStack2, (double)d, (double)(e + g * (double)0.2f), (double)f, (float)1.6f, (float)(14 - serverLevel.getDifficulty().getId() * 4));
        }
        this.playSound(VariantsAndVenturesSoundEvents.ENTITY_VERDANT_ATTACK.get(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    protected AbstractArrow getArrow(ItemStack arrow, float damageModifier, @Nullable ItemStack shotFrom) {
        AbstractArrow persistentProjectileEntity = super.getArrow(arrow, damageModifier, shotFrom);
        if (persistentProjectileEntity instanceof Arrow) {
            ((Arrow)persistentProjectileEntity).addEffect(new MobEffectInstance(MobEffects.POISON, 100));
        }
        return persistentProjectileEntity;
    }
}

