/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import org.jetbrains.annotations.Nullable;
import plus.dragons.visuality.Visuality;
import plus.dragons.visuality.config.ReloadableJsonConfig;
import plus.dragons.visuality.data.ParticleWithVelocity;
import plus.dragons.visuality.data.VisualityCodecs;
import plus.dragons.visuality.registry.VisualityParticles;

public class EntityHitParticleConfig
extends ReloadableJsonConfig {
    private boolean enabled = true;
    private int minAmount = 1;
    private int maxAmount = 20;
    private List<Entry> entries;
    private final IdentityHashMap<EntityType<?>, ParticleWithVelocity> particles = new IdentityHashMap();

    public EntityHitParticleConfig() {
        super(Visuality.location("particle_emitters/entity_hit"));
        this.entries = EntityHitParticleConfig.createDefaultEntries();
        for (Entry entry : this.entries) {
            for (EntityType<?> type : entry.entities) {
                this.particles.put(type, entry.particle);
            }
        }
    }

    public void spawnParticles(LivingEntity entity, DamageSource damageSource, double amount) {
        if (!this.enabled) {
            return;
        }
        EntityType type = entity.getType();
        if (!this.particles.containsKey(type)) {
            return;
        }
        Entity sourceEntity = damageSource.getDirectEntity();
        if (sourceEntity == null) {
            return;
        }
        if (sourceEntity instanceof LivingEntity) {
            amount = this.getAttackDamage((LivingEntity)sourceEntity);
        } else if (sourceEntity instanceof ThrownTrident) {
            amount = 8.0;
        } else if (sourceEntity instanceof AbstractArrow) {
            amount = ((AbstractArrow)sourceEntity).getBaseDamage() * 2.0;
        }
        if (amount <= 0.0) {
            return;
        }
        int count = Mth.clamp((int)Mth.ceil((double)amount), (int)this.minAmount, (int)this.maxAmount);
        ParticleWithVelocity particle = this.particles.get(entity.getType());
        double x = entity.getX();
        double y = entity.getY(0.5);
        double z = entity.getZ();
        for (int i = 0; i < count; ++i) {
            particle.spawn(entity.level(), x, y, z);
        }
    }

    private double getAttackDamage(LivingEntity attacker) {
        return attacker.getMainHandItem().getAttributeModifiers().compute(attacker.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), EquipmentSlot.MAINHAND);
    }

    @Override
    @Nullable
    protected JsonObject apply(JsonObject input, boolean config, String source, ProfilerFiller profiler) {
        JsonArray array;
        profiler.push(source);
        if (config) {
            this.enabled = GsonHelper.getAsBoolean((JsonObject)input, (String)"enabled", (boolean)true);
            this.minAmount = GsonHelper.getAsInt((JsonObject)input, (String)"min_amount", (int)1);
            this.maxAmount = GsonHelper.getAsInt((JsonObject)input, (String)"max_amount", (int)20);
        }
        if ((array = GsonHelper.getAsJsonArray((JsonObject)input, (String)"entries", null)) == null) {
            this.logger.warn("Failed to load options entries from {}: Missing JsonArray 'entries'.", (Object)source);
            profiler.pop();
            return config ? this.serializeConfig() : null;
        }
        boolean save = false;
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        ArrayList elements = Lists.newArrayList((Iterable)array);
        for (JsonElement element : elements) {
            DataResult data = Entry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (data.error().isPresent()) {
                save = config;
                this.logger.warn("Error parsing {} from {}: {}", new Object[]{this.id, source, ((DataResult.Error)data.error().get()).message()});
                continue;
            }
            if (data.result().isPresent()) {
                newEntries.add((Entry)data.result().get());
                continue;
            }
            save = config;
            this.logger.warn("Error parsing {} from {}: Missing decode result", (Object)this.id, (Object)source);
        }
        if (config) {
            this.entries = newEntries;
            this.particles.clear();
        }
        for (Entry entry : newEntries) {
            for (EntityType<?> type : entry.entities) {
                this.particles.put(type, entry.particle);
            }
        }
        profiler.pop();
        return save ? this.serializeConfig() : null;
    }

    @Override
    protected JsonObject serializeConfig() {
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(this.enabled));
        object.addProperty("min_amount", (Number)this.minAmount);
        object.addProperty("max_amount", (Number)this.maxAmount);
        object.add("entries", (JsonElement)Entry.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow());
        return object;
    }

    private static List<Entry> createDefaultEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(Entry.of((ParticleOptions)VisualityParticles.BONE.get(), EntityType.SKELETON, EntityType.SKELETON_HORSE, EntityType.STRAY));
        entries.add(Entry.of((ParticleOptions)VisualityParticles.WITHER_BONE.get(), EntityType.WITHER_SKELETON));
        entries.add(Entry.of((ParticleOptions)VisualityParticles.FEATHER.get(), EntityType.CHICKEN));
        entries.add(Entry.of((ParticleOptions)VisualityParticles.EMERALD.get(), EntityType.VILLAGER, EntityType.WANDERING_TRADER));
        return entries;
    }

    private record Entry(List<EntityType<?>> entities, ParticleWithVelocity particle) {
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VisualityCodecs.compressedListOf(BuiltInRegistries.ENTITY_TYPE.byNameCodec()).fieldOf("entity").forGetter(Entry::entities), (App)ParticleWithVelocity.CODEC.fieldOf("particle").forGetter(Entry::particle)).apply((Applicative)instance, Entry::new));
        private static final Codec<List<Entry>> LIST_CODEC = CODEC.listOf();

        private static Entry of(ParticleOptions particle, EntityType<?> ... types) {
            return new Entry(List.of(types), ParticleWithVelocity.ofZeroVelocity(particle));
        }
    }
}

