/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.caching.ItemStackPredicate;
import io.wispforest.accessories.api.equip.EquipAction;
import io.wispforest.accessories.api.equip.EquipCheck;
import io.wispforest.accessories.api.equip.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesCapability {
    @Nullable
    public static AccessoriesCapability get(@NotNull LivingEntity livingEntity) {
        return livingEntity.accessoriesCapability();
    }

    public static Optional<AccessoriesCapability> getOptionally(@NotNull LivingEntity livingEntity) {
        return Optional.ofNullable(AccessoriesCapability.get(livingEntity));
    }

    public static Collection<SlotType> getUsedSlotsFor(Player player) {
        return AccessoriesCapability.getUsedSlotsFor((LivingEntity)player, (Container)player.getInventory());
    }

    public static Collection<SlotType> getUsedSlotsFor(LivingEntity entity, Container container) {
        AccessoriesCapability capability = entity.accessoriesCapability();
        return capability != null ? capability.getUsedSlotsFor(container) : Set.of();
    }

    public LivingEntity entity();

    public void reset(boolean var1);

    public Map<String, AccessoriesContainer> getContainers();

    @Nullable
    default public AccessoriesContainer getContainer(SlotType slotType) {
        return this.getContainers().get(slotType.name());
    }

    @Nullable
    default public AccessoriesContainer getContainer(SlotTypeReference reference) {
        return this.getContainers().get(reference.slotName());
    }

    default public Collection<SlotType> getUsedSlotsFor(Container container) {
        LivingEntity entity = this.entity();
        HashSet<SlotType> slots = new HashSet<SlotType>();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            slots.addAll(SlotPredicateRegistry.getValidSlotTypes(entity, stack));
        }
        for (SlotEntryReference ref : this.getAllEquipped()) {
            slots.addAll(SlotPredicateRegistry.getValidSlotTypes(entity, ref.stack()));
        }
        slots.addAll(SlotTypeLoader.getUsedSlotsByRegistryItem(entity));
        return slots;
    }

    public void updateContainers();

    @Nullable
    default public SlotReference attemptToEquipAccessory(ItemStack stack) {
        Pair<SlotReference, Optional<ItemStack>> result = this.attemptToEquipAccessory(stack, false);
        return result != null ? (SlotReference)result.first() : null;
    }

    @Nullable
    default public Pair<SlotReference, Optional<ItemStack>> attemptToEquipAccessory(ItemStack stack, boolean allowSwapping) {
        Pair<SlotReference, EquipAction> result = this.canEquipAccessory(stack, allowSwapping, (slotStack, slotReference) -> true);
        return result != null ? Pair.of((Object)((SlotReference)result.first()), ((EquipAction)result.second()).equipStack(stack)) : null;
    }

    default public Pair<SlotReference, EquipAction> canEquipAccessory(ItemStack stack, boolean allowSwapping) {
        return this.canEquipAccessory(stack, allowSwapping, (slotStack, slotReference) -> true);
    }

    @Nullable
    public Pair<SlotReference, EquipAction> canEquipAccessory(ItemStack var1, boolean var2, EquipCheck var3);

    default public boolean isEquipped(Item item) {
        return this.isEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    default public boolean isEquipped(Item item, EquipmentChecking check) {
        return this.isEquipped(ItemStackBasedPredicate.ofItem(item), check);
    }

    default public boolean isEquipped(Predicate<ItemStack> predicate) {
        return this.isEquipped(predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    default public boolean isEquipped(Predicate<ItemStack> predicate, EquipmentChecking check) {
        return this.isEquipped(ItemStackBasedPredicate.ofPredicate(predicate), check);
    }

    default public boolean isEquipped(ItemStackBasedPredicate predicate, EquipmentChecking check) {
        return this.getFirstEquipped(predicate, check) != null;
    }

    default public boolean isAnotherEquipped(ItemStack stack, SlotReference slotReference, Item item) {
        return this.isAnotherEquipped(stack, slotReference, ItemStackBasedPredicate.ofItem(item));
    }

    default public boolean isAnotherEquipped(ItemStack stack, SlotReference slotReference, Predicate<ItemStack> predicate) {
        return this.isAnotherEquipped(stack, slotReference, ItemStackBasedPredicate.ofPredicate(predicate));
    }

    default public boolean isAnotherEquipped(ItemStack stack, SlotReference slotReference, ItemStackBasedPredicate predicate) {
        List<SlotEntryReference> equippedStacks = this.getEquipped(predicate);
        if (equippedStacks.size() > 2) {
            for (SlotEntryReference otherEntryRef : equippedStacks) {
                if (!otherEntryRef.reference().equals(slotReference)) {
                    return true;
                }
                if (otherEntryRef.stack().equals(stack)) continue;
                return true;
            }
        } else if (equippedStacks.size() == 1) {
            SlotEntryReference otherEntryRef = equippedStacks.getFirst();
            if (!otherEntryRef.reference().equals(slotReference)) {
                return true;
            }
            return !otherEntryRef.stack().equals(stack);
        }
        return false;
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(Item item) {
        return this.getFirstEquipped(item, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(Item item, EquipmentChecking check) {
        return this.getFirstEquipped(ItemStackBasedPredicate.ofItem(item), check);
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(Predicate<ItemStack> predicate) {
        return this.getFirstEquipped(predicate, EquipmentChecking.ACCESSORIES_ONLY);
    }

    @Nullable
    default public SlotEntryReference getFirstEquipped(Predicate<ItemStack> predicate, EquipmentChecking check) {
        return this.getFirstEquipped(ItemStackBasedPredicate.ofPredicate(predicate), check);
    }

    @Nullable
    public SlotEntryReference getFirstEquipped(ItemStackBasedPredicate var1, EquipmentChecking var2);

    default public List<SlotEntryReference> getEquipped(Item item) {
        return this.getEquipped(ItemStackBasedPredicate.ofItem(item));
    }

    default public List<SlotEntryReference> getEquipped(Predicate<ItemStack> predicate) {
        return this.getEquipped(ItemStackBasedPredicate.ofPredicate(predicate));
    }

    default public List<SlotEntryReference> getEquipped(ItemStackBasedPredicate predicate) {
        AccessoriesHolderLookupCache cache = AccessoriesHolderImpl.getHolder(this).getLookupCache();
        if (cache != null && !(predicate instanceof ItemStackPredicate)) {
            return cache.getEquipped(predicate);
        }
        return this.getAllEquipped().stream().filter(reference -> predicate.test(reference.stack())).toList();
    }

    default public List<SlotEntryReference> getAllEquipped() {
        return this.getAllEquipped(true);
    }

    public List<SlotEntryReference> getAllEquipped(boolean var1);

    public void addTransientSlotModifiers(Multimap<String, AttributeModifier> var1);

    public void addPersistentSlotModifiers(Multimap<String, AttributeModifier> var1);

    public void removeSlotModifiers(Multimap<String, AttributeModifier> var1);

    public Multimap<String, AttributeModifier> getSlotModifiers();

    public void clearSlotModifiers();

    public void clearCachedSlotModifiers();

    @Deprecated
    @Nullable
    default public Pair<SlotReference, List<ItemStack>> equipAccessory(ItemStack stack) {
        return this.equipAccessory(stack, false);
    }

    @Deprecated
    default public Pair<SlotReference, List<ItemStack>> equipAccessory(ItemStack stack, boolean allowSwapping) {
        ItemStack stackCopy = stack.copy();
        Pair<SlotReference, Optional<ItemStack>> result = this.attemptToEquipAccessory(stackCopy, allowSwapping);
        if (result == null) {
            return null;
        }
        ArrayList<ItemStack> returnStacks = new ArrayList<ItemStack>();
        if (!stackCopy.isEmpty()) {
            returnStacks.add(stackCopy);
        }
        ((Optional)result.second()).ifPresent(returnStacks::add);
        return Pair.of((Object)((SlotReference)result.first()), returnStacks);
    }

    @Deprecated
    @Nullable
    default public Pair<SlotReference, List<ItemStack>> equipAccessory(ItemStack stack, boolean allowSwapping, TriFunction<Accessory, ItemStack, SlotReference, Boolean> additionalCheck) {
        return this.equipAccessory(stack, allowSwapping);
    }

    @Deprecated(forRemoval=true)
    default public boolean isAnotherEquipped(SlotReference slotReference, Item item) {
        return this.isAnotherEquipped(slotReference.getStack(), slotReference, item);
    }

    @Deprecated(forRemoval=true)
    default public boolean isAnotherEquipped(SlotReference slotReference, Predicate<ItemStack> predicate) {
        return this.isAnotherEquipped(slotReference.getStack(), slotReference, predicate);
    }
}

