/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoryRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.BuiltinAccessoryRenderers;
import io.wispforest.accessories.api.client.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryRenderOverrideComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AccessoriesRendererRegistry {
    private static final Map<Item, Supplier<AccessoryRenderer>> RENDERERS = new HashMap<Item, Supplier<AccessoryRenderer>>();
    private static final Map<Item, AccessoryRenderer> CACHED_RENDERERS = new HashMap<Item, AccessoryRenderer>();

    public static void registerRenderer(Item item, Supplier<AccessoryRenderer> renderer) {
        RENDERERS.put(item, renderer);
    }

    public static void registerNoRenderer(Item item) {
        RENDERERS.put(item, () -> null);
    }

    public static void registerArmorRendering(Item item) {
        if (!AccessoriesRendererRegistry.hasRenderer(item)) {
            AccessoriesRendererRegistry.registerRenderer(item, () -> BuiltinAccessoryRenderers.ARMOR_RENDERER);
        }
    }

    public static boolean hasRenderer(Item item) {
        return RENDERERS.containsKey(item);
    }

    @Nullable
    public static AccessoryRenderer getRender(ItemStack stack) {
        boolean armorRenderOverride;
        AccessoryRenderOverrideComponent renderOverrides = (AccessoryRenderOverrideComponent)stack.getOrDefault(AccessoriesDataComponents.RENDER_OVERRIDE, (Object)AccessoryRenderOverrideComponent.DEFAULT);
        Boolean defaultRenderOverride = renderOverrides.defaultRenderOverride();
        if (defaultRenderOverride != null) {
            if (defaultRenderOverride.booleanValue()) {
                return DefaultAccessoryRenderer.INSTANCE;
            }
            if (AccessoryRegistry.isDefaultAccessory(stack)) {
                return null;
            }
        }
        if (armorRenderOverride = renderOverrides.useArmorRenderer()) {
            return BuiltinAccessoryRenderers.ARMOR_RENDERER;
        }
        return AccessoriesRendererRegistry.getRender(stack.getItem());
    }

    @Nullable
    public static AccessoryRenderer getRender(Item item) {
        AccessoryRenderer renderer = CACHED_RENDERERS.getOrDefault(item, DefaultAccessoryRenderer.INSTANCE);
        if (renderer == null && Accessories.config().clientOptions.forceNullRenderReplacement()) {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        }
        return renderer;
    }

    public static void onReload() {
        CACHED_RENDERERS.clear();
        RENDERERS.forEach((item, supplier) -> CACHED_RENDERERS.put((Item)item, (AccessoryRenderer)supplier.get()));
    }
}

