/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.client.Side;
import io.wispforest.accessories.api.client.TransformOps;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface AccessoryRenderer {
    public <S extends LivingEntityRenderState> void render(ItemStack var1, SlotReference var2, PoseStack var3, EntityModel<S> var4, S var5, MultiBufferSource var6, int var7, float var8);

    default public boolean shouldRender(boolean isRendering) {
        return isRendering;
    }

    default public boolean shouldRenderInFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference) {
        return false;
    }

    default public <S extends LivingEntityRenderState> void renderOnFirstPerson(HumanoidArm arm, ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<S> model, S renderState, MultiBufferSource multiBufferSource, int light, float partialTicks) {
        if (!this.shouldRenderInFirstPerson(arm, stack, reference)) {
            return;
        }
        this.render(stack, reference, matrices, model, renderState, multiBufferSource, light, partialTicks);
    }

    @Deprecated(forRemoval=true)
    public static void followBodyRotations(LivingEntity entity, HumanoidModel<HumanoidRenderState> model) {
        LivingEntityRenderer renderer;
        EntityModel entityModel;
        EntityRenderer render = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity);
        if (render instanceof LivingEntityRenderer && (entityModel = (renderer = (LivingEntityRenderer)render).getModel()) instanceof HumanoidModel) {
            HumanoidModel entityModel2 = (HumanoidModel)entityModel;
            entityModel2.copyPropertiesTo(model);
        }
    }

    @Deprecated
    public static void translateToFace(PoseStack poseStack, HumanoidModel<? extends HumanoidRenderState> model, LivingEntity entity) {
        AccessoryRenderer.transformToFace(poseStack, model.head, Side.FRONT);
    }

    @Deprecated(forRemoval=true)
    public static void translateToChest(PoseStack poseStack, HumanoidModel<? extends HumanoidRenderState> model, LivingEntity livingEntity) {
        AccessoryRenderer.transformToModelPart(poseStack, model.body);
    }

    @Deprecated(forRemoval=true)
    public static void translateToRightArm(PoseStack poseStack, HumanoidModel<? extends HumanoidRenderState> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.rightArm, Side.BOTTOM);
    }

    @Deprecated(forRemoval=true)
    public static void translateToLeftArm(PoseStack poseStack, HumanoidModel<? extends HumanoidRenderState> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.leftArm, Side.BOTTOM);
    }

    @Deprecated(forRemoval=true)
    public static void translateToRightLeg(PoseStack poseStack, HumanoidModel<? extends HumanoidRenderState> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.rightLeg, Side.BOTTOM);
    }

    @Deprecated(forRemoval=true)
    public static void translateToLeftLeg(PoseStack poseStack, HumanoidModel<? extends HumanoidRenderState> model, LivingEntity player) {
        AccessoryRenderer.transformToFace(poseStack, model.leftLeg, Side.BOTTOM);
    }

    public static void transformToFace(PoseStack poseStack, ModelPart part, Side side) {
        AccessoryRenderer.transformToModelPart(poseStack, part, side.direction.getStepX(), side.direction.getStepY(), side.direction.getStepZ());
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part) {
        TransformOps.transformToModelPart(poseStack, part, 0, 0, 0);
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        TransformOps.transformToModelPart(poseStack, part, xPercent, yPercent, zPercent);
    }
}

