/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.ModelTarget;
import io.wispforest.accessories.api.client.Side;
import io.wispforest.accessories.api.client.Transformation;
import io.wispforest.accessories.mixin.client.ModelPartAccessor;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class TransformOps {
    public static void transformToFace(PoseStack poseStack, ModelPart part, Side side) {
        TransformOps.transformToModelPart(poseStack, part, side.direction.getStepX(), side.direction.getStepY(), side.direction.getStepZ());
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part) {
        TransformOps.transformToModelPart(poseStack, part, 0, 0, 0);
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        part.translateAndRotate(poseStack);
        Pair<Vec3, Vec3> aabb = TransformOps.getAABB(part);
        poseStack.scale(0.0625f, 0.0625f, 0.0625f);
        poseStack.translate(xPercent != null ? Mth.lerp((double)((-xPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).x, (double)((Vec3)aabb.getSecond()).x) : 0.0, yPercent != null ? Mth.lerp((double)((-yPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).y, (double)((Vec3)aabb.getSecond()).y) : 0.0, zPercent != null ? Mth.lerp((double)((-zPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).z, (double)((Vec3)aabb.getSecond()).z) : 0.0);
        poseStack.scale(8.0f, 8.0f, 8.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
    }

    private static Pair<Vec3, Vec3> getAABB(ModelPart part) {
        Vec3 min = new Vec3(0.0, 0.0, 0.0);
        Vec3 max = new Vec3(0.0, 0.0, 0.0);
        if (part.getClass().getSimpleName().contains("EMFModelPart")) {
            ArrayList<ModelPart> parts = new ArrayList<ModelPart>();
            parts.add(part);
            parts.addAll(((ModelPartAccessor)part).getChildren().values());
            for (ModelPart modelPart : parts) {
                for (ModelPart.Cube cube : ((ModelPartAccessor)modelPart).getCubes()) {
                    min = new Vec3(Math.min(min.x, (double)Math.min(cube.minX + modelPart.x, cube.maxX + modelPart.x)), Math.min(min.y, (double)Math.min(cube.minY + modelPart.y, cube.maxY + modelPart.y)), Math.min(min.z, (double)Math.min(cube.minZ + modelPart.z, cube.maxZ + modelPart.z)));
                    max = new Vec3(Math.max(max.x, (double)Math.max(cube.minX + modelPart.x, cube.maxX + modelPart.x)), Math.max(max.y, (double)Math.max(cube.minY + modelPart.y, cube.maxY + modelPart.y)), Math.max(max.z, (double)Math.max(cube.minZ + modelPart.z, cube.maxZ + modelPart.z)));
                }
            }
        } else {
            for (ModelPart.Cube cube : ((ModelPartAccessor)part).getCubes()) {
                min = new Vec3(Math.min(min.x, (double)Math.min(cube.minX, cube.maxX)), Math.min(min.y, (double)Math.min(cube.minY, cube.maxY)), Math.min(min.z, (double)Math.min(cube.minZ, cube.maxZ)));
                max = new Vec3(Math.max(max.x, (double)Math.max(cube.minX, cube.maxX)), Math.max(max.y, (double)Math.max(cube.minY, cube.maxY)), Math.max(max.z, (double)Math.max(cube.minZ, cube.maxZ)));
            }
        }
        return Pair.of((Object)min, (Object)max);
    }

    public static void transformStack(List<Transformation> transformations, PoseStack poseStack, HumanoidModel<? extends HumanoidRenderState> model, Runnable renderCall) {
        poseStack.pushPose();
        TransformOps.transformStack(transformations, poseStack, model);
        renderCall.run();
        poseStack.popPose();
    }

    public static void transformStack(List<Transformation> transformations, PoseStack poseStack, HumanoidModel<? extends HumanoidRenderState> model) {
        for (Transformation transformation : transformations) {
            TransformOps.transform(transformation, poseStack, model);
        }
    }

    private static void transform(Transformation value, PoseStack poseStack, HumanoidModel<? extends HumanoidRenderState> model) {
        Transformation transformation = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Transformation.Translation.class, Transformation.RawRotation.class, Transformation.AxisRotation.class, Transformation.Scale.class, Transformation.TransformTo.class, Transformation.Matrix.class}, (Object)transformation, n)) {
            case 0: {
                Transformation.Translation translation = (Transformation.Translation)transformation;
                Vector3f translationVector = translation.translation();
                poseStack.translate(translationVector.x, translationVector.y, translationVector.z);
                break;
            }
            case 1: {
                Transformation.RawRotation rawRotation = (Transformation.RawRotation)transformation;
                poseStack.mulPose(rawRotation.quarternionf());
                break;
            }
            case 2: {
                Transformation.AxisRotation axisRotation = (Transformation.AxisRotation)transformation;
                poseStack.mulPose(axisRotation.axisAngle4f().get(new Quaternionf()));
                break;
            }
            case 3: {
                Transformation.Scale scale = (Transformation.Scale)transformation;
                Vector3f scaleVector = scale.scale();
                poseStack.scale(scaleVector.x, scaleVector.y, scaleVector.z);
                break;
            }
            case 4: {
                Transformation.TransformTo transformTo = (Transformation.TransformTo)transformation;
                ModelTarget modelTarget = transformTo.target();
                ModelPart part = TransformOps.getPart(modelTarget.modelPart(), model);
                if (part == null) break;
                if (modelTarget.rawNormal() != null) {
                    Vector3f axisTranslations = modelTarget.rawNormal();
                    AccessoryRenderer.transformToModelPart(poseStack, part, Float.valueOf(axisTranslations.x), Float.valueOf(axisTranslations.y), Float.valueOf(axisTranslations.z));
                    break;
                }
                if (modelTarget.side() != null) {
                    AccessoryRenderer.transformToFace(poseStack, part, modelTarget.side());
                    break;
                }
                AccessoryRenderer.transformToModelPart(poseStack, part);
                break;
            }
            case 5: {
                Transformation.Matrix matrix = (Transformation.Matrix)transformation;
                poseStack.mulPose(matrix.matrix4f());
                break;
            }
            default: {
                throw new IllegalStateException("A invalid transform was created meaning such is unable to be encoded!");
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private static ModelPart getPart(String partKey, HumanoidModel<? extends HumanoidRenderState> model) {
        return switch (partKey) {
            case "head" -> model.head;
            case "hat" -> model.hat;
            case "body" -> model.body;
            case "rightArm" -> model.rightArm;
            case "leftArm" -> model.leftArm;
            case "rightLeg" -> model.rightLeg;
            case "leftLeg" -> model.leftLeg;
            default -> null;
        };
    }
}

