/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import com.google.common.collect.ImmutableList;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public record AccessoryItemAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final AccessoryItemAttributeModifiers EMPTY = new AccessoryItemAttributeModifiers(List.of(), true);
    public static final Endec<AccessoryItemAttributeModifiers> ENDEC = StructEndecBuilder.of((StructField)Entry.ENDEC.listOf().fieldOf("modifiers", AccessoryItemAttributeModifiers::modifiers), (StructField)Endec.BOOLEAN.optionalFieldOf("show_in_tooltip", AccessoryItemAttributeModifiers::showInTooltip, (Object)true), AccessoryItemAttributeModifiers::new);

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasModifier(Holder<Attribute> holder, ResourceLocation location) {
        return this.getModifier(holder, location) != null;
    }

    @Nullable
    public AttributeModifier getModifier(Holder<Attribute> holder, ResourceLocation location) {
        for (Entry entry : this.modifiers) {
            if (!entry.attribute.equals(holder) || !entry.modifier.id().equals((Object)location)) continue;
            return entry.modifier();
        }
        return null;
    }

    public AccessoryItemAttributeModifiers withModifierAddedForAny(Holder<Attribute> holder, AttributeModifier attributeModifier, boolean isStackable) {
        return this.withModifierAdded(holder, attributeModifier, "any", isStackable);
    }

    public AccessoryItemAttributeModifiers withModifierAdded(Holder<Attribute> holder, AttributeModifier attributeModifier, String slotName, boolean isStackable) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        this.modifiers.forEach(entry -> {
            if (!entry.modifier.id().equals((Object)attributeModifier.id())) {
                builder.add(entry);
            }
        });
        builder.add((Object)new Entry(holder, attributeModifier, slotName, isStackable));
        return new AccessoryItemAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip());
    }

    public AccessoryItemAttributeModifiers withoutModifier(Holder<Attribute> holder, ResourceLocation location) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        this.modifiers.forEach(entry -> {
            if (entry.modifier.id().equals((Object)location) && entry.attribute().equals((Object)holder)) {
                return;
            }
            builder.add(entry);
        });
        return new AccessoryItemAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip());
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder gatherAttributes(SlotReference slotReference) {
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(slotReference);
        if (this.modifiers().isEmpty()) {
            return builder;
        }
        LivingEntity entity = slotReference.entity();
        Map slots = entity != null ? SlotTypeLoader.getSlotTypes(entity.level()) : Map.of();
        for (Entry entry : this.modifiers()) {
            AttributeModifier attributeModifier = entry.modifier();
            String slotTarget = entry.slotName();
            if (!slots.containsKey(slotTarget) && !slotReference.slotName().equals(slotTarget) && !slotTarget.equals("any")) continue;
            if (entry.isStackable()) {
                builder.addStackable(entry.attribute(), attributeModifier);
                continue;
            }
            builder.addExclusive(entry.attribute(), attributeModifier);
        }
        return builder;
    }

    public static class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();
        private boolean showInTooltip = true;

        private Builder() {
        }

        @Deprecated(forRemoval=true)
        @ApiStatus.ScheduledForRemoval(inVersion="1.22")
        public Builder add(Holder<Attribute> holder, AttributeModifier attributeModifier, String slotName, boolean isStackable) {
            return this.addForSlot(holder, attributeModifier, slotName, isStackable);
        }

        public Builder addForSlot(Holder<Attribute> holder, AttributeModifier attributeModifier, String slotName, boolean isStackable) {
            this.entries.add(new Entry(holder, attributeModifier, slotName, isStackable));
            return this;
        }

        public Builder addForAny(Holder<Attribute> holder, AttributeModifier attributeModifier, boolean isStackable) {
            this.entries.add(new Entry(holder, attributeModifier, "any", isStackable));
            return this;
        }

        public Builder showInTooltip(boolean value) {
            this.showInTooltip = value;
            return this;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public AccessoryItemAttributeModifiers build() {
            return new AccessoryItemAttributeModifiers(Collections.unmodifiableList(this.entries), this.showInTooltip);
        }
    }

    public record Entry(Holder<Attribute> attribute, AttributeModifier modifier, String slotName, boolean isStackable) {
        private static final Endec<Holder<Attribute>> ATTRIBUTE_ENDEC = MinecraftEndecs.IDENTIFIER.xmapWithContext((context, attributeType) -> {
            if (attributeType.getNamespace().equals("accessories")) {
                String path = attributeType.getPath();
                if (path.contains("/")) {
                    path = path.replace("/", ":");
                }
                return SlotAttribute.getAttributeHolder(path);
            }
            return (Holder)((RegistryOps.RegistryInfo)((RegistriesAttribute)context.requireAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter().lookup(Registries.ATTRIBUTE).orElseThrow(IllegalStateException::new)).getter().get(ResourceKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)attributeType)).orElseThrow(IllegalStateException::new);
        }, (context, attributeHolder) -> {
            Attribute attribute = (Attribute)attributeHolder.value();
            if (attribute instanceof SlotAttribute) {
                SlotAttribute slotAttribute = (SlotAttribute)attribute;
                String path = slotAttribute.slotName();
                if (UniqueSlotHandling.isUniqueSlot(path)) {
                    path = path.replace(":", "/");
                }
                return Accessories.of(path);
            }
            return ((RegistriesAttribute)context.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager().lookupOrThrow(Registries.ATTRIBUTE).getKey((Object)attribute);
        });
        public static final Endec<Entry> ENDEC = StructEndecBuilder.of((StructField)ATTRIBUTE_ENDEC.fieldOf("type", Entry::attribute), (StructField)AttributeUtils.ATTRIBUTE_MODIFIER_ENDEC.flatFieldOf(Entry::modifier), (StructField)Endec.STRING.fieldOf("slot_name", Entry::slotName), (StructField)Endec.BOOLEAN.optionalFieldOf("is_stackable", Entry::isStackable, (Object)false), Entry::new);
    }
}

