/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.client.MPOATVConstructingVertexConsumer;
import io.wispforest.accessories.client.PostEffectBuffer;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.compat.config.AccessoriesConfig;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import io.wispforest.accessories.pond.LivingEntityRenderStateExtension;
import java.awt.Color;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class AccessoriesRenderLayer<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final PostEffectBuffer BUFFER = new PostEffectBuffer();
    private static final float increment = 0.1f;
    private static Map<String, Float> brightnessMap = new HashMap<String, Float>();
    private static Map<String, Float> opacityMap = new HashMap<String, Float>();
    private static long lastUpdated20th = 0L;
    private boolean hasPrintedError = false;

    public AccessoriesRenderLayer(RenderLayerParent<S, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, S entityRenderState, float f, float g) {
        AccessoriesScreenBase screenBase;
        Object object;
        long current20th;
        boolean shouldUpdate;
        Optional<LivingEntity> possibleEntity = ((LivingEntityRenderStateExtension)entityRenderState).getEntity();
        if (possibleEntity.isEmpty()) {
            if (!this.hasPrintedError) {
                LOGGER.error("Unable to get the required Living Entity instance from the given LivingEntityRenderState meaning Accessories may not render!");
                this.hasPrintedError = true;
            }
            return;
        }
        LivingEntity entity = possibleEntity.get();
        float partialTicks = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(!possibleEntity.get().level().tickRateManager().isEntityFrozen((Entity)entity));
        AccessoriesCapability capability = AccessoriesCapability.get(possibleEntity.get());
        if (capability == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        float scale = (float)(1.0 + 0.5 * (0.75 + Math.sin((double)System.currentTimeMillis() / 250.0)));
        Boolean renderingLines = AccessoriesScreen.COLLECT_ACCESSORY_POSITIONS.getValue();
        Boolean useCustomerBuffer = AccessoriesScreenBase.IS_RENDERING_UI_ENTITY.getValue();
        if (!renderingLines.booleanValue() && !AccessoriesScreen.NOT_VERY_NICE_POSITIONS.isEmpty()) {
            AccessoriesScreen.NOT_VERY_NICE_POSITIONS.clear();
        }
        if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
            bufferSource.endBatch();
        }
        boolean bl = shouldUpdate = lastUpdated20th != (current20th = calendar.getTimeInMillis() / 50L);
        if (shouldUpdate) {
            lastUpdated20th = current20th;
        }
        Screen screen = Minecraft.getInstance().screen;
        AccessoriesInternalSlot selected = null;
        if (screen instanceof AccessoriesScreenBase && (object = (screenBase = (AccessoriesScreenBase)screen).getHoveredSlot()) instanceof AccessoriesInternalSlot) {
            AccessoriesInternalSlot slot;
            selected = slot = (AccessoriesInternalSlot)object;
        }
        AccessoriesConfig.ScreenOptions_.UnHoveredOptions_ unHoveredOptions = Accessories.config().screenOptions.unHoveredOptions;
        AccessoriesConfig.ScreenOptions_.HoveredOptions_ hoveredOptions = Accessories.config().screenOptions.hoveredOptions;
        for (Map.Entry entry : capability.getContainers().entrySet()) {
            AccessoriesContainer container = (AccessoriesContainer)entry.getValue();
            ExpandedSimpleContainer accessories = container.getAccessories();
            ExpandedSimpleContainer cosmetics = container.getCosmeticAccessories();
            boolean containerSelected = selected != null && selected.accessoriesContainer.slotType() == container.slotType();
            for (int i = 0; i < accessories.getContainerSize(); ++i) {
                AccessoryRenderer renderer;
                boolean isSelected;
                boolean bl2 = isSelected = containerSelected && selected.getContainerSlot() == i;
                if (shouldUpdate) {
                    Float currentBrightness = brightnessMap.getOrDefault((String)entry.getKey() + i, Float.valueOf(1.0f));
                    Float currentOpacity = opacityMap.getOrDefault((String)entry.getKey() + i, Float.valueOf(1.0f));
                    if (selected != null && !isSelected) {
                        brightnessMap.put((String)entry.getKey() + i, Float.valueOf(Math.max(unHoveredOptions.darkenedBrightness(), currentBrightness.floatValue() - 0.1f)));
                        opacityMap.put((String)entry.getKey() + i, Float.valueOf(Math.max(unHoveredOptions.darkenedOpacity(), currentOpacity.floatValue() - 0.1f)));
                    } else {
                        brightnessMap.put((String)entry.getKey() + i, Float.valueOf(Math.min(1.0f, currentBrightness.floatValue() + 0.1f)));
                        opacityMap.put((String)entry.getKey() + i, Float.valueOf(Math.min(1.0f, currentOpacity.floatValue() + 0.1f)));
                    }
                }
                ItemStack stack = accessories.getItem(i);
                ItemStack cosmeticStack = cosmetics.getItem(i);
                if (!cosmeticStack.isEmpty() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmeticStack;
                }
                if (stack.isEmpty() || (renderer = AccessoriesRendererRegistry.getRender(stack)) == null || !renderer.shouldRender(container.shouldRender(i))) continue;
                poseStack.pushPose();
                MPOATVConstructingVertexConsumer mpoatv = new MPOATVConstructingVertexConsumer();
                MutableBoolean bufferedGrabbedFlag = new MutableBoolean(false);
                MultiBufferSource innerBufferSource = renderType -> {
                    bufferedGrabbedFlag.setValue(true);
                    return useCustomerBuffer != false ? VertexMultiConsumer.create((VertexConsumer)multiBufferSource.getBuffer(renderType), (VertexConsumer)mpoatv) : multiBufferSource.getBuffer(renderType);
                };
                if (!AccessoriesScreenBase.IS_RENDERING_UI_ENTITY.getValue().booleanValue() || isSelected || selected == null || unHoveredOptions.renderUnHovered()) {
                    renderer.render(stack, SlotReference.of(entity, container.getSlotName(), i), poseStack, this.getParentModel(), entityRenderState, innerBufferSource, light, partialTicks);
                }
                float[] colorValues = null;
                if (useCustomerBuffer.booleanValue() && bufferedGrabbedFlag.getValue().booleanValue()) {
                    if (multiBufferSource instanceof MultiBufferSource.BufferSource) {
                        MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)multiBufferSource;
                        if (hoveredOptions.brightenHovered() && isSelected) {
                            if (calendar.get(2) + 1 == 5 && calendar.get(5) == 16) {
                                float hue = (float)((double)System.currentTimeMillis() / 20.0 % 360.0 / 360.0);
                                Color color = new Color(Mth.hsvToRgb((float)hue, (float)1.0f, (float)1.0f));
                                colorValues = new float[]{(float)color.getRed() / 128.0f, (float)color.getGreen() / 128.0f, (float)color.getBlue() / 128.0f, 1.0f};
                            } else {
                                float mul = hoveredOptions.cycleBrightness() ? scale : 1.5f;
                                colorValues = new float[]{mul, mul, mul, 1.0f};
                            }
                        } else if (unHoveredOptions.darkenUnHovered()) {
                            Float darkness = brightnessMap.getOrDefault((String)entry.getKey() + i, Float.valueOf(1.0f));
                            colorValues = new float[]{darkness.floatValue(), darkness.floatValue(), darkness.floatValue(), opacityMap.getOrDefault((String)entry.getKey() + i, Float.valueOf(1.0f)).floatValue()};
                        }
                        if (colorValues != null) {
                            // empty if block
                        }
                        bufferSource.endBatch();
                    }
                    if (renderingLines.booleanValue() && AccessoriesScreen.IS_RENDERING_LINE_TARGET.getValue().booleanValue()) {
                        AccessoriesScreen.NOT_VERY_NICE_POSITIONS.put(container.getSlotName() + i, mpoatv.meanPos());
                    }
                }
                poseStack.popPose();
            }
        }
    }
}

