/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.Accessories;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Sizing;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ArrowComponent
extends BaseComponent {
    protected final ResourceLocation texture = Accessories.of("textures/gui/theme/all_arrow_directions.png");
    protected final int textureWidth = 32;
    protected final int textureHeight = 32;
    protected Direction direction;
    protected boolean centered = false;
    protected final AnimatableProperty<PositionedRectangle> visibleArea;
    protected boolean blend = false;

    public ArrowComponent(Direction direction) {
        this.direction = direction;
        this.visibleArea = AnimatableProperty.of((Animatable)PositionedRectangle.of((int)0, (int)0, (int)this.regionWidth(), (int)this.regionHeight()));
    }

    protected int regionWidth() {
        return this.direction.regionWidth;
    }

    protected int regionHeight() {
        return this.direction.regionHeight;
    }

    protected int u() {
        return this.direction.u;
    }

    protected int v() {
        return this.direction.v;
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        return this.regionWidth();
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return this.regionHeight();
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.visibleArea.update(delta);
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        RenderSystem.enableDepthTest();
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((float)this.x, (float)this.y, 0.0f);
        if (this.centered) {
            matrices.translate(this.direction.getXOffset(), this.direction.getYOffset(), 0.0f);
        }
        matrices.scale((float)this.width / (float)this.regionWidth(), (float)this.height / (float)this.regionHeight(), 0.0f);
        PositionedRectangle visibleArea = (PositionedRectangle)this.visibleArea.get();
        int bottomEdge = Math.min(visibleArea.y() + visibleArea.height(), this.regionHeight());
        int rightEdge = Math.min(visibleArea.x() + visibleArea.width(), this.regionWidth());
        Function<ResourceLocation, RenderType> function = RenderType::guiTextured;
        int n = visibleArea.x();
        int n2 = visibleArea.y();
        float f = this.u() + visibleArea.x();
        float f2 = this.v() + visibleArea.y();
        int n3 = rightEdge - visibleArea.x();
        int n4 = bottomEdge - visibleArea.y();
        int n5 = rightEdge - visibleArea.x();
        int n6 = bottomEdge - visibleArea.y();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        context.blit(function, this.texture, n, n2, f, f2, n3, n4, n5, n6, 32, 32);
        if (this.blend) {
            RenderSystem.disableBlend();
        }
        matrices.popPose();
    }

    public ArrowComponent changeDirection(Direction direction) {
        this.direction = direction;
        this.resetVisibleArea();
        return this;
    }

    public ArrowComponent centered(boolean value) {
        this.centered = value;
        return this;
    }

    public ArrowComponent visibleArea(PositionedRectangle visibleArea) {
        this.visibleArea.set((Object)visibleArea);
        return this;
    }

    public ArrowComponent resetVisibleArea() {
        this.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)this.regionWidth(), (int)this.regionHeight()));
        return this;
    }

    public AnimatableProperty<PositionedRectangle> visibleArea() {
        return this.visibleArea;
    }

    public ArrowComponent blend(boolean blend) {
        this.blend = blend;
        return this;
    }

    public boolean blend() {
        return this.blend;
    }

    public static enum Direction {
        RIGHT(0, 0, 16, 14),
        LEFT(16, 0, 16, 14),
        UP(0, 16, 14, 16),
        DOWN(16, 16, 14, 16);

        public final int u;
        public final int v;
        public final int regionWidth;
        public final int regionHeight;

        private Direction(int u, int v, int regionWidth, int regionHeight) {
            this.u = u;
            this.v = v;
            this.regionWidth = regionWidth;
            this.regionHeight = regionHeight;
        }

        public float getXOffset() {
            return this == UP || this == DOWN ? 0.5f : 0.0f;
        }

        public float getYOffset() {
            return this == LEFT || this == RIGHT ? 0.5f : 0.0f;
        }
    }
}

