/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.client.gui.AccessoriesExperimentalScreen;
import io.wispforest.accessories.client.gui.components.AccessoriesContainingComponent;
import io.wispforest.accessories.client.gui.components.CollectedPositionedRectangle;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.impl.AccessoriesPlayerOptions;
import io.wispforest.accessories.menu.variants.AccessoriesExperimentalMenu;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.util.Observable;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class GriddedAccessoriesComponent
extends FlowLayout
implements AccessoriesContainingComponent {
    private final Map<Integer, PageLayouts> slotPages;
    private final Observable<Integer> pageIndex = Observable.of((Object)0);
    private final AccessoriesExperimentalScreen screen;

    protected GriddedAccessoriesComponent(AccessoriesExperimentalScreen screen, Pair<Map<Integer, PageLayouts>, Vector2i> componentData) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.VERTICAL);
        this.setupID();
        this.screen = screen;
        this.slotPages = (Map)componentData.first();
        Vector2i minimumDimensions = (Vector2i)componentData.second();
        this.build(minimumDimensions.x, minimumDimensions.y);
    }

    @Nullable
    public static GriddedAccessoriesComponent createOrNull(AccessoriesExperimentalScreen screen) {
        Pair<Map<Integer, PageLayouts>, Vector2i> data = GriddedAccessoriesComponent.buildPages(screen);
        Map slotPages = (Map)data.first();
        if (slotPages.isEmpty()) {
            return null;
        }
        return new GriddedAccessoriesComponent(screen, data);
    }

    private static Pair<Map<Integer, PageLayouts>, Vector2i> buildPages(AccessoriesExperimentalScreen screen) {
        int pageCount;
        LinkedHashMap<Integer, PageLayouts> slotPages = new LinkedHashMap<Integer, PageLayouts>();
        AccessoriesExperimentalMenu menu = (AccessoriesExperimentalMenu)screen.getMenu();
        List<Slot> slots = menu.getVisibleAccessoriesSlots();
        int pageStartingSlotIndex = 0;
        int gridSize = 6;
        int maxColumnCount = AccessoriesPlayerOptions.getOptions(menu.owner()).columnAmount();
        int maxRowCount = gridSize;
        int totalRowCount = (int)Math.ceil((float)slots.size() / 2.0f / (float)maxColumnCount);
        if (totalRowCount <= 7) {
            pageCount = 1;
            maxRowCount = 7;
        } else {
            pageCount = (int)Math.ceil((float)totalRowCount / (float)maxRowCount);
        }
        int minimumWidth = maxColumnCount * 18;
        int minimumHeight = maxRowCount * 18;
        if (totalRowCount > 0) {
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                if (pageIndex != 0) {
                    pageStartingSlotIndex += maxRowCount * maxColumnCount * 2;
                }
                int rowCount = totalRowCount < 0 ? maxRowCount + totalRowCount : maxRowCount;
                totalRowCount -= maxRowCount;
                FlowLayout accessoriesPageLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                FlowLayout cosmeticsPageLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                ArrayList<PositionedRectangle> alternativeAccessoriesChecks = new ArrayList<PositionedRectangle>();
                ArrayList<PositionedRectangle> alternativeCosmeticButtons = new ArrayList<PositionedRectangle>();
                for (int row = 0; row < rowCount; ++row) {
                    int colStartingIndex = pageStartingSlotIndex + row * (maxColumnCount * 2);
                    FlowLayout accessoriesRowLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).id("row_" + row);
                    FlowLayout cosmeticRowLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).id("row_" + row);
                    ArrayList<PositionedRectangle> accessoriesRowButtons = new ArrayList<PositionedRectangle>();
                    ArrayList<PositionedRectangle> cosmeticsRowButtons = new ArrayList<PositionedRectangle>();
                    boolean overMaxSlots = false;
                    for (int col = 0; col < maxColumnCount; ++col) {
                        int cosmetic = colStartingIndex + col * 2;
                        int accessory = cosmetic + 1;
                        if (accessory >= slots.size() || cosmetic >= slots.size()) {
                            overMaxSlots = true;
                            break;
                        }
                        AccessoriesBasedSlot cosmeticSlot = (AccessoriesBasedSlot)slots.get(cosmetic);
                        AccessoriesBasedSlot accessorySlot = (AccessoriesBasedSlot)slots.get(accessory);
                        screen.hideSlot(cosmeticSlot);
                        screen.hideSlot(accessorySlot);
                        screen.enableSlot(screen.showCosmeticState() ? cosmeticSlot : accessorySlot);
                        screen.disableSlot(screen.showCosmeticState() ? accessorySlot : cosmeticSlot);
                        Pair<io.wispforest.owo.ui.core.Component, PositionedRectangle> accessoryComponentData = ComponentUtils.slotAndToggle(accessorySlot, screen::slotAsComponent);
                        accessoriesRowLayout.child((io.wispforest.owo.ui.core.Component)accessoryComponentData.first());
                        accessoriesRowButtons.add((PositionedRectangle)accessoryComponentData.second());
                        Pair<io.wispforest.owo.ui.core.Component, PositionedRectangle> cosmeticComponentData = ComponentUtils.slotAndToggle(cosmeticSlot, screen::slotAsComponent);
                        cosmeticRowLayout.child((io.wispforest.owo.ui.core.Component)cosmeticComponentData.first());
                        cosmeticsRowButtons.add((PositionedRectangle)cosmeticComponentData.second());
                    }
                    accessoriesPageLayout.child((io.wispforest.owo.ui.core.Component)accessoriesRowLayout);
                    cosmeticsPageLayout.child((io.wispforest.owo.ui.core.Component)cosmeticRowLayout);
                    alternativeAccessoriesChecks.add(CollectedPositionedRectangle.of((PositionedRectangle)accessoriesRowLayout, accessoriesRowButtons));
                    alternativeCosmeticButtons.add(CollectedPositionedRectangle.of((PositionedRectangle)cosmeticRowLayout, cosmeticsRowButtons));
                    if (overMaxSlots) break;
                }
                slotPages.put(pageIndex, new PageLayouts(accessoriesPageLayout, cosmeticsPageLayout, alternativeAccessoriesChecks, alternativeCosmeticButtons));
            }
        }
        return Pair.of(slotPages, (Object)new Vector2i(minimumWidth, minimumHeight));
    }

    public void build(int minimumWidth, int minimumHeight) {
        int minimumLayoutHeight = minimumHeight + (this.slotPages.size() > 1 ? 30 : 0);
        io.wispforest.owo.ui.core.Component holder = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)this.getCurrentPageDefaulted().getLayout(this.screen.showCosmeticState())).id("accessories_container_holder");
        FlowLayout accessoriesMainLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(2).child(holder).horizontalAlignment(HorizontalAlignment.RIGHT).surface(ComponentUtils.getPanelSurface().and(ComponentUtils.BACKGROUND_SLOT_RENDERING_SURFACE)).padding(Insets.of((int)6)).id("accessories_layout");
        if (this.slotPages.size() <= 1) {
            this.child((io.wispforest.owo.ui.core.Component)accessoriesMainLayout);
            return;
        }
        LabelComponent pageLabel = Components.label((Component)Component.literal((String)((Integer)this.pageIndex.get() + 1 + "/" + this.slotPages.size())));
        this.pageIndex.observe(integer -> pageLabel.text((Component)Component.literal((String)((Integer)this.pageIndex.get() + 1 + "/" + this.slotPages.size()))));
        io.wispforest.owo.ui.core.Component titleBar = Containers.horizontalFlow((Sizing)Sizing.fixed((int)minimumWidth), (Sizing)Sizing.content()).child(((ButtonComponent)Components.button((Component)Component.literal((String)"<"), btn -> this.switchPage((Integer)this.pageIndex.get() - 1)).configure(btn -> btn.mouseScroll().subscribe((mouseX, mouseY, amount) -> {
            this.switchPage((int)Math.round((double)((Integer)this.pageIndex.get()).intValue() + amount));
            return true;
        }))).sizing(Sizing.fixed((int)10), Sizing.fixed((int)14)).margins(Insets.of((int)0, (int)2, (int)0, (int)2))).child(((ButtonComponent)Components.button((Component)Component.literal((String)">"), btn -> this.switchPage((Integer)this.pageIndex.get() + 1)).configure(btn -> btn.mouseScroll().subscribe((mouseX, mouseY, amount) -> {
            this.switchPage((int)Math.round((double)((Integer)this.pageIndex.get()).intValue() + amount));
            return true;
        }))).sizing(Sizing.fixed((int)10), Sizing.fixed((int)14)).margins(Insets.of((int)0, (int)2, (int)0, (int)0))).child((io.wispforest.owo.ui.core.Component)Containers.horizontalFlow((Sizing)Sizing.expand((int)100), (Sizing)Sizing.content()).child((io.wispforest.owo.ui.core.Component)pageLabel.color(Color.ofFormatting((ChatFormatting)ChatFormatting.DARK_GRAY))).horizontalAlignment(HorizontalAlignment.CENTER)).horizontalAlignment(HorizontalAlignment.RIGHT).verticalAlignment(VerticalAlignment.CENTER).id("page_title_bar");
        accessoriesMainLayout.child(0, titleBar);
        this.sizing(Sizing.content(), Sizing.fixed((int)minimumLayoutHeight));
        this.child((io.wispforest.owo.ui.core.Component)accessoriesMainLayout);
        this.child((io.wispforest.owo.ui.core.Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.expand()));
    }

    public void switchPage(int nextPageIndex) {
        this.switchPage(nextPageIndex, this.screen.showCosmeticState());
    }

    public void switchPage(int nextPageIndex, boolean showCosmeticState) {
        if (nextPageIndex >= 0 && nextPageIndex < this.slotPages.size()) {
            Integer prevPageIndex = (Integer)this.pageIndex.get();
            this.pageIndex.set((Object)nextPageIndex);
            FlowLayout lastGrid = this.slotPages.get(prevPageIndex).getLayout(showCosmeticState);
            FlowLayout activeGrid = this.slotPages.get(nextPageIndex).getLayout(showCosmeticState);
            ComponentUtils.recursiveSearch((ParentComponent)lastGrid, AccessoriesExperimentalScreen.ExtendedSlotComponent.class, slotComponent -> this.screen.hideSlot(slotComponent.slot()));
            FlowLayout titleBarComponent = (FlowLayout)this.childById(FlowLayout.class, "page_title_bar");
            FlowLayout gridContainer = (FlowLayout)titleBarComponent.parent().childById(FlowLayout.class, "accessories_container_holder");
            gridContainer.clearChildren();
            gridContainer.child((io.wispforest.owo.ui.core.Component)activeGrid);
        }
    }

    private PageLayouts getCurrentPage() {
        return this.slotPages.get(this.pageIndex.get());
    }

    private PageLayouts getCurrentPageDefaulted() {
        return this.slotPages.getOrDefault(this.pageIndex.get(), PageLayouts.DEFAULT);
    }

    @Override
    public void onCosmeticToggle(boolean showCosmeticState) {
        FlowLayout gridContainer = (FlowLayout)this.childById(FlowLayout.class, "accessories_container_holder");
        gridContainer.clearChildren();
        for (PageLayouts pageLayout : this.slotPages.values()) {
            FlowLayout lastGrid = pageLayout.getLayout(!showCosmeticState);
            this.updateDisabledStateSlots((ParentComponent)lastGrid, (ParentComponent)pageLayout.getLayout(showCosmeticState));
        }
        FlowLayout activeGrid = this.getCurrentPageDefaulted().getLayout(showCosmeticState);
        gridContainer.child((io.wispforest.owo.ui.core.Component)activeGrid);
    }

    @Override
    @Nullable
    public Boolean isHovering_Logical(Slot slot, double mouseX, double mouseY) {
        for (PositionedRectangle child : this.getCurrentPageDefaulted().getAlternativeChecks(this.screen.showCosmeticState())) {
            if (!child.isInBoundingBox(mouseX, mouseY)) continue;
            return false;
        }
        return null;
    }

    private void updateDisabledStateSlots(ParentComponent prevComp, ParentComponent newComp) {
        ComponentUtils.recursiveSearch(prevComp, AccessoriesExperimentalScreen.ExtendedSlotComponent.class, slotComponent -> this.screen.disableSlot(slotComponent.slot()));
        ComponentUtils.recursiveSearch(newComp, AccessoriesExperimentalScreen.ExtendedSlotComponent.class, slotComponent -> this.screen.enableSlot(slotComponent.slot()));
    }

    public record PageLayouts(FlowLayout accessoriesLayout, FlowLayout cosmeticLayout, List<PositionedRectangle> alternativeAccessoriesChecks, List<PositionedRectangle> alternativeCosmeticChecks) {
        public static final PageLayouts DEFAULT = new PageLayouts(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()), Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()), List.of(), List.of());

        public FlowLayout getLayout(boolean isCosmetic) {
            return isCosmetic ? this.cosmeticLayout : this.accessoriesLayout;
        }

        public List<PositionedRectangle> getAlternativeChecks(boolean isCosmetic) {
            return isCosmetic ? this.alternativeCosmeticChecks : this.alternativeAccessoriesChecks;
        }
    }
}

