/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.commands.CommandBuilderHelper;
import io.wispforest.accessories.commands.RecordArgumentTypeInfo;
import io.wispforest.accessories.commands.ResourceExtendedArgument;
import io.wispforest.accessories.commands.SlotArgumentType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class AccessoriesCommands
extends CommandBuilderHelper {
    public static final AccessoriesCommands INSTANCE = new AccessoriesCommands();
    private static final SimpleCommandExceptionType NON_LIVING_ENTITY_TARGET = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.livingEntities.nonLiving"));
    public static final SimpleCommandExceptionType INVALID_SLOT_TYPE = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid Slot Type"));
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((var1, var2, var3) -> Component.translatableEscape((String)"commands.attribute.failed.modifier_already_present_itemstack", (Object[])new Object[]{var1, var2, var3}));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((var1, var2, var3) -> Component.translatableEscape((String)"commands.attribute.failed.no_modifier_itemstack", (Object[])new Object[]{var1, var2, var3}));

    @Override
    public void registerArgumentTypes(CommandBuilderHelper.ArgumentRegistration registration) {
        registration.register(Accessories.of("slot_type"), SlotArgumentType.class, RecordArgumentTypeInfo.of(ctx -> SlotArgumentType.INSTANCE));
        registration.register(Accessories.of("resource"), ResourceExtendedArgument.class, RecordArgumentTypeInfo.of(ResourceExtendedArgument::attributes));
    }

    public static LivingEntity getOrThrowLivingEntity(CommandContext<CommandSourceStack> ctx, String name) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(ctx, (String)name);
        if (!(entity instanceof LivingEntity)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity;
    }

    @Override
    protected void generateTrees(CommandBuildContext context) {
        this.getOrCreateNode("accessories").requires(stack -> stack.hasPermission(2));
        this.optionalArgExectution("accessories/edit", this.argumentHolder("entity", (ArgumentType<?>)EntityArgument.entity(), AccessoriesCommands::getOrThrowLivingEntity), (CommandContext<CommandSourceStack> ctx, T1 livingEntity) -> {
            Accessories.askPlayerForVariant(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), livingEntity);
            return 1;
        });
        this.requiredArgExectution("accessories/nest", this.argumentHolder("item", (ArgumentType<?>)ItemArgument.item((CommandBuildContext)context), (ctx, name) -> ItemArgument.getItem((CommandContext)ctx, (String)name).createItemStack(1, false)), (CommandContext<CommandSourceStack> ctx, T1 innerStack) -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            player.getMainHandItem().update(AccessoriesDataComponents.NESTED_ACCESSORIES, (Object)AccessoryNestContainerContents.EMPTY, data -> data.addStack((ItemStack)innerStack));
            return 1;
        });
        CommandBuilderHelper.CommandArgumentHolder<String> slotArgument = this.argumentHolder("slot", SlotArgumentType.INSTANCE, SlotArgumentType::getSlot);
        List<String> slotGroupings = List.of("valid", "invalid");
        this.requiredArgExectutionBranched("accessories/slot/add", slotGroupings, slotArgument, (CommandContext<CommandSourceStack> ctx, String branch, T1 slot) -> AccessoriesCommands.adjustSlotValidationOnStack(Objects.equals(branch, "valid"), true, slot, (CommandContext<CommandSourceStack>)ctx));
        this.requiredArgExectutionBranched("accessories/slot/remove", slotGroupings, slotArgument, (CommandContext<CommandSourceStack> ctx, String branch, T1 slot) -> AccessoriesCommands.adjustSlotValidationOnStack(Objects.equals(branch, "valid"), false, slot, (CommandContext<CommandSourceStack>)ctx));
        this.requiredArgExectution("accessories/stack-sizing/useStackSize", this.argumentHolder("value", (ArgumentType<?>)BoolArgumentType.bool(), (ctx, name) -> (Boolean)ctx.getArgument(name, Boolean.class)), (CommandContext<CommandSourceStack> ctx, T1 bl) -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            player.getMainHandItem().update(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT, component -> component.useStackSize((boolean)bl));
            return 1;
        });
        this.requiredArgExectution("accessories/stack-sizing", this.argumentHolder("size", (ArgumentType<?>)IntegerArgumentType.integer(), (ctx, name) -> (Integer)ctx.getArgument(name, Integer.class)), (CommandContext<CommandSourceStack> ctx, T1 size) -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            player.getMainHandItem().update(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT, component -> component.sizeOverride((int)size));
            return 1;
        });
        CommandBuilderHelper.CommandArgumentHolder<Holder> attributeArg = this.argumentHolder("attribute", ResourceExtendedArgument.attributes(context), ResourceExtendedArgument::getAttribute);
        CommandBuilderHelper.CommandArgumentHolder<ResourceLocation> idArg = this.argumentHolder("id", (ArgumentType<?>)ResourceLocationArgument.id(), ResourceLocationArgument::getId);
        ArgumentBuilder modifierAdd = this.getOrCreateNode("accessories/attribute/modifier/add", attributeArg, idArg, this.argumentHolder("amount", (ArgumentType<?>)DoubleArgumentType.doubleArg(), DoubleArgumentType::getDouble));
        modifierAdd.then(AccessoriesCommands.createAddLiteral("add_value")).then(AccessoriesCommands.createAddLiteral("add_multiplied_base")).then(AccessoriesCommands.createAddLiteral("add_multiplied_total"));
        this.updateParent(modifierAdd);
        this.requiredArgExectution("accessories/attribute/modifier/remove", attributeArg, idArg, AccessoriesCommands::removeModifier);
        this.requiredArgExectution("accessories/attribute/modifier/get", attributeArg, idArg, (CommandContext<CommandSourceStack> ctx, T1 attributeHolder, T2 location) -> AccessoriesCommands.getAttributeModifier((CommandContext<CommandSourceStack>)ctx, (Holder<Attribute>)((Holder)attributeArg.getArgument((CommandContext<CommandSourceStack>)ctx)), (ResourceLocation)idArg.getArgument((CommandContext<CommandSourceStack>)ctx), 1.0));
        this.requiredArgExectution("accessories/attribute/modifier/get", attributeArg, idArg, this.argumentHolder("scale", (ArgumentType<?>)DoubleArgumentType.doubleArg(), DoubleArgumentType::getDouble), (CommandContext<CommandSourceStack> ctx, T1 attributeHolder, T2 location, T3 scale) -> AccessoriesCommands.getAttributeModifier((CommandContext<CommandSourceStack>)ctx, (Holder<Attribute>)((Holder)attributeArg.getArgument((CommandContext<CommandSourceStack>)ctx)), (ResourceLocation)idArg.getArgument((CommandContext<CommandSourceStack>)ctx), scale));
        DynamicCommandExceptionType logFailureType = new DynamicCommandExceptionType(branch -> Component.literal((String)("Unable to locate the given logging for the following command branch: " + String.valueOf(branch))));
        this.requiredExectutionBranched("accessories/log", List.of("slots", "groups", "entity_bindings"), (CommandContext<CommandSourceStack> ctx, String branch) -> {
            switch (branch) {
                case "slots": {
                    LOGGER.info("All given Slots registered:");
                    for (SlotType slotType : SlotTypeLoader.getSlotTypes((Level)((CommandSourceStack)ctx.getSource()).getLevel()).values()) {
                        LOGGER.info(slotType.toString());
                    }
                    break;
                }
                case "groups": {
                    LOGGER.info("All given Slot Groups registered:");
                    for (SlotGroup group : SlotGroupLoader.getGroups((Level)((CommandSourceStack)ctx.getSource()).getLevel())) {
                        LOGGER.info(group.toString());
                    }
                    break;
                }
                case "entity_bindings": {
                    LOGGER.info("All given Entity Bindings registered:");
                    EntitySlotLoader.INSTANCE.getEntitySlotData(false).forEach((type, slots) -> LOGGER.info("[{}]: {}", type, slots.keySet()));
                    break;
                }
                default: {
                    throw logFailureType.create(branch);
                }
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createAddLiteral(String literal) {
        AttributeModifier.Operation selectedValue = Arrays.stream(AttributeModifier.Operation.values()).filter(value -> value.getSerializedName().equals(literal)).findFirst().orElse(null);
        if (selectedValue == null) {
            throw new IllegalStateException("Unable to handle the given literal as its not a valid AttributeModifier Operation! [Literal: " + literal + "]");
        }
        return (LiteralArgumentBuilder)Commands.literal((String)literal).then(Commands.argument((String)"slot", (ArgumentType)SlotArgumentType.INSTANCE).then(Commands.argument((String)"isStackable", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> AccessoriesCommands.addModifier((CommandSourceStack)ctx.getSource(), (LivingEntity)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), ResourceExtendedArgument.getAttribute((CommandContext<CommandSourceStack>)ctx, "attribute"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"id"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"amount"), selectedValue, SlotArgumentType.getSlot((CommandContext<CommandSourceStack>)ctx, "slot"), BoolArgumentType.getBool((CommandContext)ctx, (String)"isStackable")))));
    }

    private static int getAttributeModifier(CommandContext<CommandSourceStack> ctx, Holder<Attribute> holder, ResourceLocation resourceLocation, double d) throws CommandSyntaxException {
        CommandSourceStack commandSourceStack = (CommandSourceStack)ctx.getSource();
        ServerPlayer livingEntity = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack stack = livingEntity.getMainHandItem();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.getOrDefault(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        AttributeModifier modifier = component.getModifier(holder, resourceLocation);
        if (modifier == null) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)stack.getDisplayName(), (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)resourceLocation);
        }
        double e = modifier.amount();
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"commands.attribute.modifier.value.get.success_itemstack", (Object[])new Object[]{Component.translationArg((ResourceLocation)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.getDisplayName(), e}), false);
        return (int)(e * d);
    }

    private static int addModifier(CommandSourceStack commandSourceStack, LivingEntity livingEntity, Holder<Attribute> holder, ResourceLocation resourceLocation, double d, AttributeModifier.Operation operation, String slotName, boolean isStackable) throws CommandSyntaxException {
        ItemStack stack = livingEntity.getMainHandItem();
        AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)stack.getOrDefault(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
        if (component.hasModifier(holder, resourceLocation)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)resourceLocation, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.getDisplayName());
        }
        stack.set(AccessoriesDataComponents.ATTRIBUTES, (Object)component.withModifierAdded(holder, new AttributeModifier(resourceLocation, d, operation), slotName, isStackable));
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"commands.attribute.modifier.add.success_itemstack", (Object[])new Object[]{Component.translationArg((ResourceLocation)resourceLocation), AccessoriesCommands.getAttributeDescription(holder), stack.getDisplayName()}), false);
        return 1;
    }

    private static int removeModifier(CommandContext<CommandSourceStack> ctx, Holder<Attribute> holder, ResourceLocation location) throws CommandSyntaxException {
        CommandSourceStack commandSourceStack = (CommandSourceStack)ctx.getSource();
        ServerPlayer livingEntity = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        MutableBoolean removedModifier = new MutableBoolean(false);
        ItemStack stack = livingEntity.getMainHandItem();
        stack.update(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY, component -> {
            int size = component.modifiers().size();
            if (size != (component = component.withoutModifier(holder, location)).modifiers().size()) {
                removedModifier.setTrue();
            }
            return component;
        });
        if (!removedModifier.getValue().booleanValue()) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)location, (Object)AccessoriesCommands.getAttributeDescription(holder), (Object)stack.getDisplayName());
        }
        commandSourceStack.sendSuccess(() -> Component.translatable((String)"commands.attribute.modifier.remove.success_itemstack", (Object[])new Object[]{Component.translationArg((ResourceLocation)location), AccessoriesCommands.getAttributeDescription(holder), stack.getDisplayName()}), false);
        return 1;
    }

    private static Component getAttributeDescription(Holder<Attribute> attribute) {
        return Component.translatable((String)((Attribute)attribute.value()).getDescriptionId());
    }

    private static int adjustSlotValidationOnStack(boolean validSlot, boolean addSlot, String slotName, CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer targetEntity = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        targetEntity.getMainHandItem().update(AccessoriesDataComponents.SLOT_VALIDATION, (Object)AccessorySlotValidationComponent.EMPTY, component -> validSlot ? (addSlot ? component.addValidSlot(slotName) : component.removeValidSlot(slotName)) : (addSlot ? component.addInvalidSlot(slotName) : component.removeInvalidSlot(slotName)));
        return 1;
    }
}

