/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class Key {
    private final List<String> path;

    public Key(String key) {
        this(key.split("/"));
    }

    public Key(String ... keyParts) {
        this(List.of(keyParts));
    }

    public Key(List<String> keyParts) {
        this.path = ImmutableList.copyOf(keyParts);
    }

    public Key child(String keyPart) {
        ArrayList<String> parts = new ArrayList<String>(this.path);
        parts.add(keyPart);
        return new Key(parts);
    }

    @Nullable
    public Key parent() {
        if (this.path.size() - 1 <= 0) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>(this.path);
        parts.removeLast();
        return new Key(parts);
    }

    public String topPath() {
        return this.path.getLast();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Key)) return false;
        Key otherKey = (Key)obj;
        if (!this.path.equals(otherKey.path)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }
}

