/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import java.util.List;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;

public class VanillaItemPredicates {
    public static final SlotBasedPredicate ELYTRA_PREDICATE = (level, slotType, slot, stack) -> {
        List<String> validSlots = Accessories.config().contentOptions.validGliderSlots();
        if (stack.has(DataComponents.GLIDER)) {
            if ((validSlots.contains(slotType.name()) || validSlots.contains("any")) && Accessories.config().contentOptions.allowGliderEquip()) {
                return TriState.TRUE;
            }
            if (slotType.name().equals("cape") && stack.is(AccessoriesTags.VALID_GLIDER_EQUIP)) {
                return TriState.TRUE;
            }
        }
        return TriState.DEFAULT;
    };
    public static final SlotBasedPredicate TOTEM_PREDICATE = (level, slotType, slot, stack) -> {
        List<String> validSlots = Accessories.config().contentOptions.validTotemSlots();
        if (stack.has(DataComponents.DEATH_PROTECTION)) {
            if ((validSlots.contains(slotType.name()) || validSlots.contains("any")) && Accessories.config().contentOptions.allowTotemEquip()) {
                return TriState.TRUE;
            }
            if (slotType.name().equals("charm") && stack.is(AccessoriesTags.VALID_TOTEM_EQUIP)) {
                return TriState.TRUE;
            }
        }
        return TriState.DEFAULT;
    };
    public static final SlotBasedPredicate BANNER_PREDICATE = (level, slotType, slot, stack) -> {
        List<String> validSlots = Accessories.config().contentOptions.validBannerSlots();
        if (stack.getItem() instanceof BannerItem && (validSlots.contains(slotType.name()) || validSlots.contains("any")) && Accessories.config().contentOptions.allowBannerEquip()) {
            return TriState.TRUE;
        }
        return TriState.DEFAULT;
    };

    public static void init() {
        SlotPredicateRegistry.register(Accessories.of("elytra_item"), ELYTRA_PREDICATE);
        SlotPredicateRegistry.register(Accessories.of("totem_item"), TOTEM_PREDICATE);
        SlotPredicateRegistry.register(Accessories.of("banner_item"), BANNER_PREDICATE);
    }
}

