/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu.variants;

import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.menu.variants.AccessoriesExperimentalMenu;
import io.wispforest.accessories.mixin.CraftingMenuAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.ScreenOpen;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AccessoriesMenuBase
extends AbstractCraftingMenu {
    protected final Player owner;
    @Nullable
    protected final LivingEntity targetEntity;
    private static final Slot EMPTY_SLOT = new Slot((Container)new SimpleContainer(1), 0, 0, 0);

    protected AccessoriesMenuBase(MenuType<? extends AccessoriesMenuBase> menuType, int containerId, Inventory inventory, int width, int height, @Nullable LivingEntity targetEntity) {
        super(menuType, containerId, width, height);
        this.owner = inventory.player;
        this.targetEntity = targetEntity;
        if (this instanceof AccessoriesExperimentalMenu) {
            this.addResultSlot(inventory.player, 154, 28);
            this.addCraftingGridSlots(98, 18);
        }
    }

    public final AccessoriesMenuVariant menuVariant() {
        return AccessoriesMenuVariant.getVariant((MenuType<? extends AccessoriesMenuBase>)this.getType());
    }

    public Slot getResultSlot() {
        return this instanceof AccessoriesExperimentalMenu ? (Slot)this.slots.get(0) : EMPTY_SLOT;
    }

    public List<Slot> getInputGridSlots() {
        return this instanceof AccessoriesExperimentalMenu ? this.slots.subList(1, 5) : List.of();
    }

    @Nullable
    public final LivingEntity targetEntity() {
        return this.targetEntity;
    }

    public final Player owner() {
        return this.owner;
    }

    public final void reopenMenu() {
        AccessoriesNetworking.sendToServer(ScreenOpen.of(this.targetEntity(), this.menuVariant()));
    }

    @Nullable
    public Pair<ItemStack, ItemStack> quickMoveStackCrafting(int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            ItemStack itemStack = itemStack2.copy();
            int endIndex = 41;
            if (index == 0) {
                if (!this.moveItemStackTo(itemStack2, 5, endIndex, true)) {
                    return Pair.of((Object)ItemStack.EMPTY, null);
                }
                slot.onQuickCraft(itemStack2, itemStack);
            } else if (index >= 1 && index < 5 && !this.moveItemStackTo(itemStack2, 5, endIndex, false)) {
                return Pair.of((Object)ItemStack.EMPTY, null);
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return null;
            }
            return Pair.of((Object)itemStack, (Object)itemStack2);
        }
        return null;
    }

    public void fillCraftSlotsStackedContents(StackedItemContents stackedItemContents) {
        this.craftSlots.fillStackedContents(stackedItemContents);
    }

    public void clearCraftingContent() {
        this.resultSlots.clearContent();
        this.craftSlots.clearContent();
    }

    public boolean recipeMatches(RecipeHolder<CraftingRecipe> recipe) {
        return ((CraftingRecipe)recipe.value()).matches((RecipeInput)this.craftSlots.asCraftInput(), this.owner.level());
    }

    public void slotsChanged(Container container) {
        Level level = this.owner.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        CraftingMenuAccessor.accessories$slotChangedCraftingGrid((AbstractContainerMenu)this, serverLevel, this.owner, this.craftSlots, this.resultSlots, (RecipeHolder<CraftingRecipe>)((RecipeHolder)null));
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultSlots.clearContent();
        if (!player.level().isClientSide) {
            this.clearContainer(player, (Container)this.craftSlots);
        }
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(stack, slot);
    }

    public int getResultSlotIndex() {
        return -1;
    }

    public int getGridWidth() {
        return this.craftSlots.getWidth();
    }

    public int getGridHeight() {
        return this.craftSlots.getHeight();
    }

    public int getSize() {
        return this.craftSlots.getWidth() * this.craftSlots.getHeight() + 1;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    public boolean shouldMoveToInventory(int slotIndex) {
        return slotIndex != this.getResultSlotIndex();
    }
}

