/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import io.wispforest.accessories.pond.EnchantedItemInUseExtension;
import io.wispforest.owo.Owo;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    @Shadow
    protected static void runIterationOnItem(ItemStack itemStack, EquipmentSlot equipmentSlot, LivingEntity livingEntity, EnchantmentHelper.EnchantmentInSlotVisitor enchantmentInSlotVisitor) {
    }

    @WrapOperation(method={"getEnchantmentLevel(Lnet/minecraft/core/Holder;Lnet/minecraft/world/entity/LivingEntity;)I"}, at={@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;")})
    private static Collection<ItemStack> addAccessoriesStacks(Map instance, Operation<Collection<ItemStack>> original, @Local(argsOnly=true) Holder<Enchantment> enchantment, @Local(argsOnly=true) LivingEntity entity) {
        ArrayList<ItemStack> returnValue = new ArrayList<ItemStack>((Collection)original.call(new Object[]{instance}));
        AccessoriesCapability capability = entity.accessoriesCapability();
        if (capability != null) {
            returnValue.addAll(capability.getAllEquipped().stream().map(SlotEntryReference::stack).toList());
        }
        return returnValue;
    }

    @Inject(method={"getRandomItemWith(Lnet/minecraft/core/component/DataComponentType;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getRandom()Lnet/minecraft/util/RandomSource;")})
    private static void adjustListForAccessories(DataComponentType<?> dataComponentType, LivingEntity livingEntity, Predicate<ItemStack> predicate, CallbackInfoReturnable<Optional<EnchantedItemInUse>> cir, @Local(ordinal=0) List<EnchantedItemInUse> list) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability != null) {
            List<EnchantedItemInUse> allEquippedAccessories = capability.getAllEquipped().stream().filter(entryReference -> {
                ItemStack itemStack = entryReference.stack();
                if (predicate.test(entryReference.stack())) {
                    ItemEnchantments itemEnchantments = (ItemEnchantments)itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                    for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                        Boolean valid;
                        Holder holder = (Holder)entry.getKey();
                        if (!((Enchantment)holder.value()).effects().has(dataComponentType) || (valid = EnchantmentHelperMixin.enchantmentValidForRedirect(livingEntity.registryAccess(), (Enchantment)holder.value())) == null) continue;
                        return valid;
                    }
                }
                return false;
            }).map(entryReference -> ((EnchantedItemInUseExtension)new EnchantedItemInUse(entryReference.stack(), AccessoriesInternals.INTERNAL_SLOT, livingEntity, item -> entryReference.reference().breakStack())).setSlotReference(entryReference.reference())).toList();
            list.addAll(allEquippedAccessories);
        }
    }

    @Inject(method={"runIterationOnEquipment(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V"}, at={@At(value="TAIL")})
    private static void adjustIterationWithAccessories(LivingEntity livingEntity, EnchantmentHelper.EnchantmentInSlotVisitor enchantmentInSlotVisitor, CallbackInfo ci) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability != null) {
            capability.getAllEquipped().forEach(entryReference -> {
                ItemStack itemStack = entryReference.stack();
                ((AccessoriesLivingEntityExtension)livingEntity).pushEnchantmentContext(itemStack, entryReference.reference());
                EnchantmentHelperMixin.runIterationOnItem(itemStack, AccessoriesInternals.INTERNAL_SLOT, livingEntity, enchantmentInSlotVisitor);
            });
        }
    }

    @ModifyExpressionValue(method={"runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/Enchantment;matchingSlot(Lnet/minecraft/world/entity/EquipmentSlot;)Z")})
    private static boolean adjustIfIterationOccurs(boolean original, @Local(argsOnly=true) EquipmentSlot equipmentSlot, @Local(argsOnly=true) LivingEntity livingEntity, @Local(ordinal=0) Holder<Enchantment> holder) {
        Boolean valid;
        if (equipmentSlot.equals((Object)AccessoriesInternals.INTERNAL_SLOT) && (valid = EnchantmentHelperMixin.enchantmentValidForRedirect(livingEntity.registryAccess(), (Enchantment)holder.value())) != null) {
            return valid;
        }
        return original;
    }

    @WrapOperation(method={"runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V"}, at={@At(value="NEW", target="(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/enchantment/EnchantedItemInUse;")})
    private static EnchantedItemInUse addSlotReferenceToEnchantRecord(ItemStack itemStack, EquipmentSlot inSlot, LivingEntity owner, Operation<EnchantedItemInUse> original) {
        SlotReference ref;
        EnchantedItemInUse record = null;
        if (inSlot.equals((Object)AccessoriesInternals.INTERNAL_SLOT) && (ref = ((AccessoriesLivingEntityExtension)owner).popEnchantmentContext(itemStack)) != null) {
            record = new EnchantedItemInUse(itemStack, inSlot, owner, item -> ref.breakStack());
            ((EnchantedItemInUseExtension)record).setSlotReference(ref);
        }
        if (record == null) {
            record = (EnchantedItemInUse)original.call(new Object[]{itemStack, inSlot, owner});
        }
        return record;
    }

    @WrapOperation(method={"lambda$forEachModifier$30(Lnet/minecraft/core/Holder;Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;ILnet/minecraft/world/item/enchantment/effects/EnchantmentAttributeEffect;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/Enchantment;matchingSlot(Lnet/minecraft/world/entity/EquipmentSlot;)Z")})
    private static boolean allowAccessoriesSlotEnchentments(Enchantment instance, EquipmentSlot slot, Operation<Boolean> original) {
        Boolean valid;
        if (slot.equals((Object)AccessoriesInternals.INTERNAL_SLOT) && (valid = EnchantmentHelperMixin.enchantmentValidForRedirect(null, instance)) != null) {
            return valid;
        }
        return (Boolean)original.call(new Object[]{instance, slot});
    }

    @Unique
    @Nullable
    private static Boolean enchantmentValidForRedirect(@Nullable RegistryAccess access, Enchantment enchantment) {
        Registry enchantments;
        if (access != null) {
            enchantments = access.lookupOrThrow(Registries.ENCHANTMENT);
        } else {
            MinecraftServer server = Owo.currentServer();
            if (server != null) {
                enchantments = server.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            } else {
                return null;
            }
        }
        return !((Holder.Reference)enchantments.get((ResourceKey)enchantments.getResourceKey((Object)enchantment).orElseThrow()).orElseThrow()).is(AccessoriesTags.INVALID_FOR_REDIRECTION);
    }
}

