/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={CompoundTag.class})
public abstract class NbtCompoundMixin {
    @Shadow
    @Nullable
    public abstract Tag get(String var1);

    @Inject(method={"hasUUID(Ljava/lang/String;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;get(Ljava/lang/String;)Lnet/minecraft/nbt/Tag;", shift=At.Shift.BY, by=2)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void adjustCheckForListVariants(String key, CallbackInfoReturnable<Boolean> cir, Tag tag) {
        ListTag listTag;
        if (tag instanceof ListTag && (listTag = (ListTag)tag).getElementType() == 3 && listTag.size() == 4) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getByteArray(Ljava/lang/String;)[B"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;contains(Ljava/lang/String;I)Z")}, cancellable=true)
    private void adjustByteArrayForRegularList(String key, CallbackInfoReturnable<byte[]> cir) {
        ListTag listTag;
        Tag tag = this.get(key);
        if (tag instanceof ListTag && (listTag = (ListTag)tag).getElementType() == 1) {
            byte[] array = new byte[listTag.size()];
            for (int i = 0; i < listTag.size(); ++i) {
                Tag tagEntry = listTag.get(i);
                array[i] = ((NumericTag)tagEntry).getAsByte();
            }
            cir.setReturnValue((Object)array);
        }
    }

    @Inject(method={"getIntArray(Ljava/lang/String;)[I"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;contains(Ljava/lang/String;I)Z")}, cancellable=true)
    private void adjustIntArrayForRegularList(String key, CallbackInfoReturnable<int[]> cir) {
        ListTag listTag;
        Tag tag = this.get(key);
        if (tag instanceof ListTag && (listTag = (ListTag)tag).getElementType() == 3) {
            int[] array = new int[listTag.size()];
            for (int i = 0; i < listTag.size(); ++i) {
                Tag tagEntry = listTag.get(i);
                array[i] = ((NumericTag)tagEntry).getAsInt();
            }
            cir.setReturnValue((Object)array);
        }
    }

    @Inject(method={"getLongArray(Ljava/lang/String;)[J"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;contains(Ljava/lang/String;I)Z")}, cancellable=true)
    private void adjustLongArrayForRegularList(String key, CallbackInfoReturnable<long[]> cir) {
        ListTag listTag;
        Tag tag = this.get(key);
        if (tag instanceof ListTag && (listTag = (ListTag)tag).getElementType() == 4) {
            long[] array = new long[listTag.size()];
            for (int i = 0; i < listTag.size(); ++i) {
                Tag tagEntry = listTag.get(i);
                array[i] = ((NumericTag)tagEntry).getAsLong();
            }
            cir.setReturnValue((Object)array);
        }
    }
}

