/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.equip.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.pond.LivingEntityRenderStateExtension;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={CapeLayer.class})
public abstract class CapeLayerMixin {
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Unique
    private boolean hasPrintedError = false;
    @Shadow
    @Final
    private EquipmentAssetManager equipmentAssets;

    @WrapOperation(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/CapeLayer;hasLayer(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;)Z")})
    private boolean accessories$adjustGliderStackCheck(CapeLayer instance, ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Operation<Boolean> original, @Local(argsOnly=true) PlayerRenderState playerRenderState) {
        if (playerRenderState instanceof LivingEntityRenderStateExtension) {
            LivingEntityRenderStateExtension extension = (LivingEntityRenderStateExtension)playerRenderState;
            Optional<LivingEntity> entity = extension.getEntity();
            if (entity.isPresent()) {
                SlotEntryReference gliderItem;
                AccessoriesCapability capability = entity.get().accessoriesCapability();
                if (capability != null && (gliderItem = capability.getFirstEquipped(stack1 -> {
                    Equippable equippable = (Equippable)stack1.get(DataComponents.EQUIPPABLE);
                    if (equippable != null && equippable.assetId().isPresent()) {
                        List list = this.equipmentAssets.get((ResourceKey)equippable.assetId().get()).getLayers(EquipmentClientInfo.LayerType.WINGS);
                        return !list.isEmpty();
                    }
                    return false;
                }, EquipmentChecking.COSMETICALLY_OVERRIDABLE)) != null) {
                    itemStack = gliderItem.stack();
                }
            } else if (!this.hasPrintedError) {
                LOGGER.error("Unable to get the required Living Entity instance from the given LivingEntityRenderState meaning Accessories may not render!");
                this.hasPrintedError = true;
            }
        }
        return (Boolean)original.call(new Object[]{instance, itemStack, layerType});
    }
}

