/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel model, float shadowRadius) {
        super(context, (EntityModel)model, shadowRadius);
    }

    @Inject(method={"renderHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/model/geom/ModelPart;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/geom/ModelPart;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V", ordinal=0, shift=At.Shift.AFTER)})
    private void accessories$firstPersonAccessories(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, ResourceLocation resourceLocation, ModelPart rendererArm, boolean bl, CallbackInfo ci, @Local PlayerModel playerModel) {
        LocalPlayer player = Minecraft.getInstance().player;
        Level level = Minecraft.getInstance().player.level();
        float partialTicks = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(!level.tickRateManager().isEntityFrozen((Entity)player));
        PlayerRenderState state = (PlayerRenderState)this.createRenderState((Entity)player, partialTicks);
        HumanoidArm currentArm = rendererArm == ((PlayerModel)this.model).leftArm ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability == null) {
            return;
        }
        for (Map.Entry<String, AccessoriesContainer> entry : capability.getContainers().entrySet()) {
            AccessoriesContainer container = entry.getValue();
            ExpandedSimpleContainer accessories = container.getAccessories();
            ExpandedSimpleContainer cosmetics = container.getCosmeticAccessories();
            for (int i = 0; i < accessories.getContainerSize(); ++i) {
                AccessoryRenderer renderer;
                ItemStack stack = accessories.getItem(i);
                ItemStack cosmeticStack = cosmetics.getItem(i);
                if (!cosmeticStack.isEmpty() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmeticStack;
                }
                if (stack.isEmpty() || (renderer = AccessoriesRendererRegistry.getRender(stack)) == null || !renderer.shouldRender(container.shouldRender(i))) continue;
                poseStack.pushPose();
                renderer.renderOnFirstPerson(currentArm, stack, SlotReference.of((LivingEntity)player, container.getSlotName(), i), poseStack, playerModel, state, buffer, combinedLight, partialTicks);
                poseStack.popPose();
            }
        }
    }
}

