/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.client.gui.ScreenVariantSelectionScreen;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.ScreenOpen;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public record ScreenVariantPing(int entityId, boolean targetLookEntity) {
    public static final StructEndec<ScreenVariantPing> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", ScreenVariantPing::entityId), (StructField)Endec.BOOLEAN.fieldOf("targetLookEntity", ScreenVariantPing::targetLookEntity), ScreenVariantPing::new);

    public static ScreenVariantPing of(@Nullable LivingEntity livingEntity) {
        return new ScreenVariantPing(livingEntity != null ? livingEntity.getId() : -1, false);
    }

    public static ScreenVariantPing of(boolean targetLookEntity) {
        return new ScreenVariantPing(-1, targetLookEntity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(ScreenVariantPing packet, Player player) {
        AccessoriesMenuVariant selectedVariant = AccessoriesMenuVariant.getVariant(Accessories.config().screenOptions.selectedScreenType());
        Function<AccessoriesMenuVariant, ScreenOpen> packetBuilder = menuVariant -> new ScreenOpen(packet.targetLookEntity() ? -1 : packet.entityId(), packet.targetLookEntity(), (AccessoriesMenuVariant)((Object)menuVariant));
        if (selectedVariant != null) {
            AccessoriesNetworking.sendToServer(packetBuilder.apply(selectedVariant));
        } else {
            Minecraft.getInstance().setScreen((Screen)new ScreenVariantSelectionScreen(variant -> AccessoriesNetworking.sendToServer((ScreenOpen)packetBuilder.apply((AccessoriesMenuVariant)((Object)variant)))));
        }
    }
}

