/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.api.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.network.clientbound.SyncMooshroomExtrasClientboundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record MooshroomExtrasAttachment(boolean hasSnow, boolean snowLayerPersistent, boolean allowShearing, boolean allowConversion) {
    public static final ResourceLocation ID = BovinesAndButtercups.asResource("mooshroom_extras");
    public static final MooshroomExtrasAttachment DEFAULT = new MooshroomExtrasAttachment();
    public static final Codec<MooshroomExtrasAttachment> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("has_snow", (Object)false).forGetter(MooshroomExtrasAttachment::hasSnow), (App)Codec.BOOL.optionalFieldOf("snow_layer_persistent", (Object)false).forGetter(MooshroomExtrasAttachment::snowLayerPersistent), (App)Codec.BOOL.optionalFieldOf("allow_shearing", (Object)true).forGetter(MooshroomExtrasAttachment::allowShearing), (App)Codec.BOOL.optionalFieldOf("allow_conversion", (Object)true).forGetter(MooshroomExtrasAttachment::allowConversion)).apply((Applicative)inst, MooshroomExtrasAttachment::new));

    public MooshroomExtrasAttachment() {
        this(false, false, true, true);
    }

    public static void sync(LivingEntity entity) {
        if (entity.level().isClientSide()) {
            return;
        }
        BovinesAndButtercups.getHelper().sendTrackingClientboundPacket((Entity)entity, new SyncMooshroomExtrasClientboundPacket(entity.getId(), BovinesAndButtercups.getHelper().getMooshroomExtrasAttachment(entity), false));
    }

    public static void syncToPlayer(LivingEntity entity, ServerPlayer player) {
        if (entity.level().isClientSide()) {
            return;
        }
        BovinesAndButtercups.getHelper().sendClientboundPacket(player, new SyncMooshroomExtrasClientboundPacket(entity.getId(), BovinesAndButtercups.getHelper().getMooshroomExtrasAttachment(entity), false));
    }
}

