/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.api.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.access.MobEffectInstanceLockdownDataAccess;
import house.greenhouse.bovinesandbuttercups.content.block.PlaceableEdibleBlock;
import house.greenhouse.bovinesandbuttercups.content.block.entity.PlaceableEdibleBlockEntity;
import house.greenhouse.bovinesandbuttercups.content.component.ItemEdible;
import house.greenhouse.bovinesandbuttercups.content.effect.BovinesEffects;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import house.greenhouse.bovinesandbuttercups.util.BlockUtil;
import house.greenhouse.bovinesandbuttercups.util.CreativeModeTabEntry;
import house.greenhouse.bovinesandbuttercups.util.FloatRange;
import house.greenhouse.bovinesandbuttercups.util.IntRange;
import house.greenhouse.bovinesandbuttercups.util.LockdownData;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.ApiStatus;

public record EdibleBlockType(Optional<ResourceLocation> itemModel, int bites, int maxStackSize, Map<BlockValuesEntry, VoxelShape> shapes, Map<HolderSet<Item>, AttachmentEntry> attachable, Map<BlockValuesEntry, List<ParticleEntry>> particlePositions, List<CreativeModeTabEntry> creativeModeTabs) {
    private static final Codec<Pair<BlockValuesEntry, List<ParticleEntry>>> PARTICLE_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BlockValuesEntry.CODEC.fieldOf("comparable").forGetter(Pair::getFirst), (App)ParticleEntry.CODEC.listOf().fieldOf("particles").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));
    private static final Codec<Pair<BlockValuesEntry, VoxelShape>> SHAPE_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BlockValuesEntry.CODEC.fieldOf("comparable").forGetter(Pair::getFirst), (App)BlockUtil.VOXEL_SHAPE_CODEC.fieldOf("shape").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));
    private static final Codec<Pair<BlockValuesEntry, Integer>> LIGHT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BlockValuesEntry.CODEC.fieldOf("comparable").forGetter(Pair::getFirst), (App)Codec.intRange((int)0, (int)15).fieldOf("level").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));
    public static final Codec<EdibleBlockType> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.optionalFieldOf("item_model").forGetter(EdibleBlockType::itemModel), (App)Codec.intRange((int)1, (int)16).fieldOf("bites").forGetter(EdibleBlockType::bites), (App)Codec.intRange((int)1, (int)99).fieldOf("stack_size").forGetter(EdibleBlockType::maxStackSize), (App)SHAPE_CODEC.listOf().fieldOf("shapes").xmap(pairs -> pairs.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (object, object2) -> object, () -> new Object2ObjectLinkedOpenHashMap())), map -> map.entrySet().stream().map(entry -> Pair.of((Object)((BlockValuesEntry)entry.getKey()), (Object)((VoxelShape)entry.getValue()))).toList()).forGetter(EdibleBlockType::shapes), (App)Codec.simpleMap((Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM), AttachmentEntry.CODEC, (Keyable)Keyable.forStrings(() -> Stream.of("items", "values"))).codec().optionalFieldOf("attachments", Map.of()).forGetter(EdibleBlockType::attachable), (App)PARTICLE_CODEC.listOf().optionalFieldOf("particles", List.of()).xmap(pairs -> pairs.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (object, object2) -> object, () -> new Object2ObjectLinkedOpenHashMap())), map -> map.entrySet().stream().map(entry -> Pair.of((Object)((BlockValuesEntry)entry.getKey()), (Object)((List)entry.getValue()))).toList()).forGetter(EdibleBlockType::particlePositions), (App)CreativeModeTabEntry.CODEC.listOf().optionalFieldOf("creative_mode_tabs", List.of()).forGetter(EdibleBlockType::creativeModeTabs)).apply((Applicative)inst, EdibleBlockType::new));
    public static final Codec<Holder<EdibleBlockType>> CODEC = RegistryFixedCodec.create(BovinesRegistryKeys.EDIBLE_BLOCK_TYPE);
    public static final ResourceKey<EdibleBlockType> MISSING_KEY = ResourceKey.create(BovinesRegistryKeys.EDIBLE_BLOCK_TYPE, (ResourceLocation)BovinesAndButtercups.asResource("missing_edible"));

    public static EdibleBlockType cupcake(BootstrapContext<EdibleBlockType> context, MobEffectInstance instance, Optional<ResourceLocation> itemModel) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)context.lookup(Registries.ITEM).getOrThrow(ItemTags.CANDLES), (Object)new AttachmentEntry(4, Map.of(BlockValuesEntry.builder().addAttachment((HolderSet<Item>)context.lookup(Registries.ITEM).getOrThrow(ItemTags.CANDLES), BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(1).active(true)).build(), 3, BlockValuesEntry.builder().addAttachment((HolderSet<Item>)context.lookup(Registries.ITEM).getOrThrow(ItemTags.CANDLES), BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(2).active(true)).build(), 3, BlockValuesEntry.builder().addAttachment((HolderSet<Item>)context.lookup(Registries.ITEM).getOrThrow(ItemTags.CANDLES), BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(3).active(true)).build(), 3, BlockValuesEntry.builder().addAttachment((HolderSet<Item>)context.lookup(Registries.ITEM).getOrThrow(ItemTags.CANDLES), BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(4).active(true)).build(), 3), List.of(new ActivationEntry(Ingredient.of((HolderSet)context.lookup(Registries.ITEM).getOrThrow(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/igniter")))), true, Optional.of(new SoundSettings((Holder<SoundEvent>)((Holder)context.lookup(Registries.SOUND_EVENT).get(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)SoundEvents.FLINTANDSTEEL_USE.location())).orElseThrow()), 1.0f, FloatRange.exact(1.0f), FloatRange.exact(1.0f))), Map.of(), List.of(InvertedLootItemCondition.invert((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setFluid(FluidPredicate.Builder.fluid().of((HolderSet)context.lookup(Registries.FLUID).getOrThrow(FluidTags.WATER))))).build())), new ActivationEntry(Ingredient.of((ItemLike)Items.FIRE_CHARGE), true, Optional.of(new SoundSettings((Holder<SoundEvent>)((Holder)context.lookup(Registries.SOUND_EVENT).get(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)SoundEvents.FIRECHARGE_USE.location())).orElseThrow()), 1.0f, FloatRange.exact(1.0f), FloatRange.exact(1.0f))), Map.of(), List.of(InvertedLootItemCondition.invert((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setFluid(FluidPredicate.Builder.fluid().of((HolderSet)context.lookup(Registries.FLUID).getOrThrow(FluidTags.WATER))))).build())), new ActivationEntry(Optional.empty(), false, Optional.of(new SoundSettings((Holder<SoundEvent>)((Holder)context.lookup(Registries.SOUND_EVENT).get(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)SoundEvents.CANDLE_EXTINGUISH.location())).orElseThrow()), 1.0f, FloatRange.exact(1.0f), FloatRange.exact(1.0f))), EdibleBlockType.createEmptyActivationParticles(context), List.of())), Optional.of(new SoundSettings((Holder<SoundEvent>)((Holder)context.lookup(Registries.SOUND_EVENT).get(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)SoundEvents.CAKE_ADD_CANDLE.location())).orElseThrow()), 1.0f, FloatRange.exact(1.0f), FloatRange.exact(1.0f)))));
        MobEffectInstance inst = new MobEffectInstance(BovinesEffects.LOCKDOWN, instance.getDuration() / 4);
        ((MobEffectInstanceLockdownDataAccess)inst).bovinesandbuttercups$setLockdownData(List.of(new LockdownData((Holder<MobEffect>)instance.getEffect())));
        CreativeModeTabEntry.ComponentsEntry componentsEntry = new CreativeModeTabEntry.ComponentsEntry(DataComponentMap.EMPTY, List.of(new ItemEdible.MobEffectEntry(inst, instance.getDuration(), ItemEdible.MobEffectEntry.ShowTooltip.ALWAYS)));
        return new EdibleBlockType(itemModel, 4, 16, EdibleBlockType.createCupcakeShapeMap(context), (Map<HolderSet<Item>, AttachmentEntry>)builder.build(), EdibleBlockType.createParticlePositionMap(context), List.of(new CreativeModeTabEntry((ResourceKey<CreativeModeTab>)ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"food_and_drinks")), List.of(componentsEntry), new CreativeModeTabEntry.PlacementEntry(Optional.of(Either.right((Object)Items.CAKE)), CreativeModeTabEntry.Ordering.AFTER))));
    }

    public static EdibleBlockType puffPastry(BootstrapContext<EdibleBlockType> context, Optional<ResourceLocation> itemModel) {
        return new EdibleBlockType(itemModel, 4, 16, EdibleBlockType.createPuffPastryShapeMap(context), Map.of(), Map.of(), List.of(new CreativeModeTabEntry((ResourceKey<CreativeModeTab>)ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"food_and_drinks")), List.of(), new CreativeModeTabEntry.PlacementEntry(Optional.of(Either.right((Object)Items.CAKE)), CreativeModeTabEntry.Ordering.AFTER))));
    }

    public static EdibleBlockType suspiciousPuffPastry(BootstrapContext<EdibleBlockType> context, Optional<ResourceLocation> itemModel) {
        return new EdibleBlockType(itemModel, 4, 16, EdibleBlockType.createPuffPastryShapeMap(context), Map.of(), Map.of(), List.of(new CreativeModeTabEntry((ResourceKey<CreativeModeTab>)ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"food_and_drinks")), List.of(), new CreativeModeTabEntry.PlacementEntry(Optional.of(Either.right((Object)Items.CAKE)), CreativeModeTabEntry.Ordering.AFTER))));
    }

    private static Map<BlockValuesEntry, VoxelShape> createPuffPastryShapeMap(BootstrapContext<EdibleBlockType> context) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        BlockValuesEntry.Builder oneEntry = BlockValuesEntry.builder();
        oneEntry.exactBiteCount(1);
        VoxelShape one = Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)2.0, (double)10.5);
        map.put(oneEntry.build(), one);
        BlockValuesEntry.Builder twoEntry = BlockValuesEntry.builder();
        twoEntry.exactBiteCount(2);
        VoxelShape two = Block.box((double)3.0, (double)0.0, (double)2.5, (double)9.5, (double)2.0, (double)13.3);
        map.put(twoEntry.build(), two);
        BlockValuesEntry.Builder threeEntry = BlockValuesEntry.builder();
        threeEntry.exactBiteCount(3);
        VoxelShape three = Block.box((double)3.0, (double)0.0, (double)2.5, (double)13.5, (double)2.0, (double)13.3);
        map.put(threeEntry.build(), three);
        BlockValuesEntry.Builder fourEntry = BlockValuesEntry.builder();
        fourEntry.lowerBoundBiteCount(4);
        VoxelShape four = Block.box((double)3.0, (double)0.0, (double)2.5, (double)13.5, (double)4.0, (double)13.3);
        map.put(fourEntry.build(), four);
        return map;
    }

    private static Map<BlockValuesEntry, VoxelShape> createCupcakeShapeMap(BootstrapContext<EdibleBlockType> context) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        HolderSet.Named candles = context.lookup(Registries.ITEM).getOrThrow(ItemTags.CANDLES);
        BlockValuesEntry.Builder oneEntry = BlockValuesEntry.builder();
        oneEntry.exactBiteCount(1);
        oneEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(0));
        VoxelShape one = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
        BlockValuesEntry.Builder oneCandleEntry = BlockValuesEntry.builder();
        oneCandleEntry.exactBiteCount(1);
        oneCandleEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(1));
        VoxelShape oneCandle = Shapes.or((VoxelShape)one, (VoxelShape)Block.box((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0));
        map.put(oneEntry.build(), one);
        map.put(oneCandleEntry.build(), oneCandle);
        BlockValuesEntry.Builder twoEntry = BlockValuesEntry.builder();
        twoEntry.exactBiteCount(2);
        twoEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(0));
        VoxelShape two = Block.box((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)5.0, (double)11.0);
        BlockValuesEntry.Builder twoOneCandleEntry = BlockValuesEntry.builder();
        twoOneCandleEntry.exactBiteCount(2);
        twoOneCandleEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(1));
        VoxelShape twoOneCandle = Shapes.or((VoxelShape)two, (VoxelShape)Block.box((double)11.0, (double)5.0, (double)7.0, (double)13.0, (double)9.0, (double)9.0));
        BlockValuesEntry.Builder twoTwoCandlesEntry = BlockValuesEntry.builder();
        twoTwoCandlesEntry.exactBiteCount(2);
        twoTwoCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(2));
        VoxelShape twoTwoCandles = Shapes.or((VoxelShape)twoOneCandle, (VoxelShape)Block.box((double)3.0, (double)5.0, (double)7.0, (double)5.0, (double)8.0, (double)9.0));
        map.put(twoEntry.build(), two);
        map.put(twoOneCandleEntry.build(), twoOneCandle);
        map.put(twoTwoCandlesEntry.build(), twoTwoCandles);
        BlockValuesEntry.Builder threeEntry = BlockValuesEntry.builder();
        threeEntry.exactBiteCount(3);
        threeEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(0));
        VoxelShape threeFour = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);
        BlockValuesEntry.Builder threeOneCandleEntry = BlockValuesEntry.builder();
        threeOneCandleEntry.exactBiteCount(3);
        threeOneCandleEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(1));
        VoxelShape threeOneCandle = Shapes.or((VoxelShape)threeFour, (VoxelShape)Block.box((double)11.0, (double)5.0, (double)3.0, (double)13.0, (double)9.0, (double)5.0));
        BlockValuesEntry.Builder threeTwoCandlesEntry = BlockValuesEntry.builder();
        threeTwoCandlesEntry.exactBiteCount(3);
        threeTwoCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(2));
        VoxelShape threeTwoCandles = Shapes.or((VoxelShape)threeOneCandle, (VoxelShape)Block.box((double)3.0, (double)5.0, (double)3.0, (double)5.0, (double)8.0, (double)5.0));
        BlockValuesEntry.Builder threeThreeCandlesEntry = BlockValuesEntry.builder();
        threeThreeCandlesEntry.exactBiteCount(3);
        threeThreeCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(3));
        VoxelShape threeThreeCandles = Shapes.or((VoxelShape)threeTwoCandles, (VoxelShape)Block.box((double)7.0, (double)5.0, (double)11.0, (double)9.0, (double)10.0, (double)13.0));
        map.put(threeEntry.build(), threeFour);
        map.put(threeOneCandleEntry.build(), threeOneCandle);
        map.put(threeTwoCandlesEntry.build(), threeTwoCandles);
        map.put(threeThreeCandlesEntry.build(), threeThreeCandles);
        BlockValuesEntry.Builder fourEntry = BlockValuesEntry.builder();
        fourEntry.lowerBoundBiteCount(4);
        fourEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(0));
        BlockValuesEntry.Builder fourOneCandleEntry = BlockValuesEntry.builder();
        fourOneCandleEntry.lowerBoundBiteCount(4);
        fourOneCandleEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(1));
        VoxelShape fourOneCandle = Shapes.or((VoxelShape)threeFour, (VoxelShape)Block.box((double)11.0, (double)5.0, (double)3.0, (double)13.0, (double)9.0, (double)5.0));
        BlockValuesEntry.Builder fourTwoCandlesEntry = BlockValuesEntry.builder();
        fourTwoCandlesEntry.lowerBoundBiteCount(4);
        fourTwoCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(2));
        VoxelShape fourTwoCandles = Shapes.or((VoxelShape)fourOneCandle, (VoxelShape)Block.box((double)3.0, (double)5.0, (double)3.0, (double)5.0, (double)8.0, (double)5.0));
        BlockValuesEntry.Builder fourThreeCandlesEntry = BlockValuesEntry.builder();
        fourThreeCandlesEntry.lowerBoundBiteCount(4);
        fourThreeCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(3));
        VoxelShape fourThreeCandles = Shapes.or((VoxelShape)fourTwoCandles, (VoxelShape)Block.box((double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)10.0, (double)13.0));
        BlockValuesEntry.Builder fourFourCandlesEntry = BlockValuesEntry.builder();
        fourFourCandlesEntry.lowerBoundBiteCount(4);
        fourFourCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(4));
        VoxelShape fourFourCandles = Shapes.or((VoxelShape)fourThreeCandles, (VoxelShape)Block.box((double)11.0, (double)5.0, (double)3.0, (double)13.0, (double)9.0, (double)5.0));
        map.put(fourEntry.build(), threeFour);
        map.put(fourOneCandleEntry.build(), fourOneCandle);
        map.put(fourTwoCandlesEntry.build(), fourTwoCandles);
        map.put(fourThreeCandlesEntry.build(), fourThreeCandles);
        map.put(fourFourCandlesEntry.build(), fourFourCandles);
        return map;
    }

    private static Map<BlockValuesEntry, List<ParticleEntry>> createParticlePositionMap(BootstrapContext<EdibleBlockType> context) {
        Holder.Reference candleAmbient = context.lookup(Registries.SOUND_EVENT).getOrThrow(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)SoundEvents.CANDLE_AMBIENT.location()));
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        HolderSet.Named candles = context.lookup(Registries.ITEM).getOrThrow(ItemTags.CANDLES);
        BlockValuesEntry.Builder oneEntry = BlockValuesEntry.builder();
        oneEntry.exactBiteCount(1);
        oneEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(1).active(true));
        ImmutableList one = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.5, 0.6875, 0.5), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.5, 0.6875, 0.5), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))));
        map.put(oneEntry.build(), one);
        BlockValuesEntry.Builder twoOneCandleEntry = BlockValuesEntry.builder();
        twoOneCandleEntry.exactBiteCount(2);
        twoOneCandleEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(1).active(true));
        ImmutableList twoOneCandle = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.6875, 0.5), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.5), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))));
        BlockValuesEntry.Builder twoTwoCandlesEntry = BlockValuesEntry.builder();
        twoTwoCandlesEntry.exactBiteCount(2);
        twoTwoCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(2).active(true));
        ImmutableList twoTwoCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.6875, 0.5), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.5), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.25, 0.625, 0.5), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.5), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))));
        map.put(twoOneCandleEntry.build(), twoOneCandle);
        map.put(twoTwoCandlesEntry.build(), twoTwoCandles);
        BlockValuesEntry.Builder threeOneCandleEntry = BlockValuesEntry.builder();
        threeOneCandleEntry.exactBiteCount(3);
        threeOneCandleEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(1).active(true));
        ImmutableList threeOneCandle = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))));
        BlockValuesEntry.Builder threeTwoCandlesEntry = BlockValuesEntry.builder();
        threeTwoCandlesEntry.exactBiteCount(3);
        threeTwoCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(2).active(true));
        ImmutableList threeTwoCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.25, 0.625, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))));
        BlockValuesEntry.Builder threeThreeCandlesEntry = BlockValuesEntry.builder();
        threeThreeCandlesEntry.exactBiteCount(3);
        threeThreeCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(3).active(true));
        ImmutableList threeThreeCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.25, 0.625, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.5, 0.75, 0.75), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.5, 0.75, 0.75), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))));
        map.put(threeOneCandleEntry.build(), threeOneCandle);
        map.put(threeTwoCandlesEntry.build(), threeTwoCandles);
        map.put(threeThreeCandlesEntry.build(), threeThreeCandles);
        BlockValuesEntry.Builder fourOneCandleEntry = BlockValuesEntry.builder();
        fourOneCandleEntry.lowerBoundBiteCount(4);
        fourOneCandleEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(1).active(true));
        ImmutableList fourOneCandle = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))));
        BlockValuesEntry.Builder fourTwoCandlesEntry = BlockValuesEntry.builder();
        fourTwoCandlesEntry.lowerBoundBiteCount(4);
        fourTwoCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(2).active(true));
        ImmutableList fourTwoCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.25, 0.625, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))));
        BlockValuesEntry.Builder fourThreeCandlesEntry = BlockValuesEntry.builder();
        fourThreeCandlesEntry.lowerBoundBiteCount(4);
        fourThreeCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(3).active(true));
        ImmutableList fourThreeCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.25, 0.625, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.75, 0.75), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.75, 0.75), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))));
        BlockValuesEntry.Builder fourFourCandlesEntry = BlockValuesEntry.builder();
        fourFourCandlesEntry.lowerBoundBiteCount(4);
        fourFourCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(4).active(true));
        ImmutableList fourFourCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.25, 0.625, 0.25), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.25), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.75, 0.75, 0.75), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.75, 0.75), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.FLAME, new Vec3(0.25, 0.6875, 0.75), Vec3.ZERO, 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.6875, 0.75), Vec3.ZERO, 0.3f, Optional.of(new SoundSettings((Holder<SoundEvent>)candleAmbient, 0.17f, FloatRange.range(1.0f, 1.1f), FloatRange.range(0.3f, 1.0f)))));
        map.put(fourOneCandleEntry.build(), fourOneCandle);
        map.put(fourTwoCandlesEntry.build(), fourTwoCandles);
        map.put(fourThreeCandlesEntry.build(), fourThreeCandles);
        map.put(fourFourCandlesEntry.build(), fourFourCandles);
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EdibleBlockType)) {
            return false;
        }
        EdibleBlockType edibleBlockType = (EdibleBlockType)obj;
        return edibleBlockType.creativeModeTabs.equals(this.creativeModeTabs) && edibleBlockType.particlePositions.equals(this.particlePositions) && edibleBlockType.attachable.equals(this.attachable) && edibleBlockType.shapes.equals(this.shapes) && edibleBlockType.maxStackSize == this.maxStackSize && edibleBlockType.bites == this.bites;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bites, this.maxStackSize, this.shapes, this.attachable, this.particlePositions, this.creativeModeTabs);
    }

    private static Map<BlockValuesEntry, List<ParticleEntry>> createEmptyActivationParticles(BootstrapContext<EdibleBlockType> context) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        HolderSet.Named candles = context.lookup(Registries.ITEM).getOrThrow(ItemTags.CANDLES);
        BlockValuesEntry.Builder oneEntry = BlockValuesEntry.builder();
        oneEntry.exactBiteCount(1);
        oneEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(1).active(true));
        ImmutableList one = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.5, 0.6875, 0.5), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()));
        map.put(oneEntry.build(), one);
        BlockValuesEntry.Builder twoOneCandleEntry = BlockValuesEntry.builder();
        twoOneCandleEntry.exactBiteCount(2);
        twoOneCandleEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(1).active(true));
        ImmutableList twoOneCandle = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.5), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()));
        BlockValuesEntry.Builder twoTwoCandlesEntry = BlockValuesEntry.builder();
        twoTwoCandlesEntry.exactBiteCount(2);
        twoTwoCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(2).active(true));
        ImmutableList twoTwoCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.5), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.5), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()));
        map.put(twoOneCandleEntry.build(), twoOneCandle);
        map.put(twoTwoCandlesEntry.build(), twoTwoCandles);
        BlockValuesEntry.Builder threeOneCandleEntry = BlockValuesEntry.builder();
        threeOneCandleEntry.exactBiteCount(3);
        threeOneCandleEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(1).active(true));
        ImmutableList threeOneCandle = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()));
        BlockValuesEntry.Builder threeTwoCandlesEntry = BlockValuesEntry.builder();
        threeTwoCandlesEntry.exactBiteCount(3);
        threeTwoCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(2).active(true));
        ImmutableList threeTwoCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()));
        BlockValuesEntry.Builder threeThreeCandlesEntry = BlockValuesEntry.builder();
        threeThreeCandlesEntry.exactBiteCount(3);
        threeThreeCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(3).active(true));
        ImmutableList threeThreeCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.5, 0.75, 0.75), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()));
        map.put(threeOneCandleEntry.build(), threeOneCandle);
        map.put(threeTwoCandlesEntry.build(), threeTwoCandles);
        map.put(threeThreeCandlesEntry.build(), threeThreeCandles);
        BlockValuesEntry.Builder fourOneCandleEntry = BlockValuesEntry.builder();
        fourOneCandleEntry.lowerBoundBiteCount(4);
        fourOneCandleEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(1).active(true));
        ImmutableList fourOneCandle = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()));
        BlockValuesEntry.Builder fourTwoCandlesEntry = BlockValuesEntry.builder();
        fourTwoCandlesEntry.lowerBoundBiteCount(4);
        fourTwoCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(2).active(true));
        ImmutableList fourTwoCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()));
        BlockValuesEntry.Builder fourThreeCandlesEntry = BlockValuesEntry.builder();
        fourThreeCandlesEntry.lowerBoundBiteCount(4);
        fourThreeCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().exactCount(3).active(true));
        ImmutableList fourThreeCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.75, 0.75), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()));
        BlockValuesEntry.Builder fourFourCandlesEntry = BlockValuesEntry.builder();
        fourFourCandlesEntry.lowerBoundBiteCount(4);
        fourFourCandlesEntry.addAttachment((HolderSet<Item>)candles, BlockValuesEntry.AttachmentValueEntry.builder().lowerBoundCount(4).active(true));
        ImmutableList fourFourCandles = ImmutableList.of((Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.6875, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.625, 0.25), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.75, 0.75, 0.75), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()), (Object)new ParticleEntry((ParticleOptions)ParticleTypes.SMOKE, new Vec3(0.25, 0.6875, 0.75), new Vec3(0.0, (double)0.1f, 0.0), 1.0f, Optional.empty()));
        map.put(fourOneCandleEntry.build(), fourOneCandle);
        map.put(fourTwoCandlesEntry.build(), fourTwoCandles);
        map.put(fourThreeCandlesEntry.build(), fourThreeCandles);
        map.put(fourFourCandlesEntry.build(), fourFourCandles);
        return map;
    }

    @ApiStatus.Internal
    public static EdibleBlockType missingEdible(BootstrapContext<EdibleBlockType> context) {
        return new EdibleBlockType(Optional.empty(), 1, 64, Map.of(BlockValuesEntry.builder().lowerBoundBiteCount(1).build(), Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)2.0, (double)10.5)), Map.of(), Map.of(), List.of());
    }

    public record AttachmentEntry(int maxCount, Map<BlockValuesEntry, Integer> lightLevel, List<ActivationEntry> activations, Optional<SoundSettings> sound) {
        public static final Codec<AttachmentEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)1, (int)16).fieldOf("max_count").forGetter(AttachmentEntry::maxCount), (App)LIGHT_CODEC.listOf().xmap(pairs -> pairs.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (object, object2) -> object, () -> new Object2ObjectLinkedOpenHashMap())), map -> map.entrySet().stream().map(entry -> Pair.of((Object)((BlockValuesEntry)entry.getKey()), (Object)((Integer)entry.getValue()))).toList()).optionalFieldOf("light", Map.of()).forGetter(AttachmentEntry::lightLevel), (App)ActivationEntry.CODEC.listOf().fieldOf("activations").forGetter(AttachmentEntry::activations), (App)SoundSettings.CODEC.optionalFieldOf("sound").forGetter(AttachmentEntry::sound)).apply((Applicative)inst, AttachmentEntry::new));
    }

    public record BlockValuesEntry(Optional<IntRange> biteCount, Map<HolderSet<Item>, AttachmentValueEntry> attachments) {
        public static final Codec<BlockValuesEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)IntRange.codec(0, 16).optionalFieldOf("bite_count").forGetter(BlockValuesEntry::biteCount), (App)Codec.simpleMap((Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM), AttachmentValueEntry.CODEC, (Keyable)Keyable.forStrings(() -> Stream.of("items", "values"))).codec().optionalFieldOf("attachments", Map.of()).forGetter(BlockValuesEntry::attachments)).apply((Applicative)inst, BlockValuesEntry::new));

        public boolean test(PlaceableEdibleBlockEntity blockEntity) {
            if (blockEntity.getEdibleType() == null || !blockEntity.getEdibleType().holder().isBound()) {
                return false;
            }
            return !(!this.biteCount.isEmpty() && !this.biteCount.get().test((Integer)blockEntity.getBlockState().getValue((Property)PlaceableEdibleBlock.BITES)) || !this.attachments.isEmpty() && !this.attachments.entrySet().stream().allMatch(entry -> {
                if (!blockEntity.getAttachments().containsKey(entry.getKey())) {
                    return !(!((AttachmentValueEntry)entry.getValue()).item.isEmpty() && !((AttachmentValueEntry)entry.getValue()).item.stream().allMatch(predicate -> predicate.test(ItemStack.EMPTY)) || !((AttachmentValueEntry)entry.getValue()).count.test(0) || !((AttachmentValueEntry)entry.getValue()).active.isEmpty() && ((AttachmentValueEntry)entry.getValue()).active.get() != false);
                }
                List<Map.Entry> list = blockEntity.getAttachments().entrySet().stream().filter(e -> ((HolderSet)e.getKey()).equals(entry.getKey()) && ((PlaceableEdibleBlockEntity.AttachmentState)e.getValue()).items().isEmpty() && ((AttachmentValueEntry)entry.getValue()).item.stream().allMatch(predicate -> predicate.test(ItemStack.EMPTY)) && this.attachments.get(entry.getKey()).count.test(((PlaceableEdibleBlockEntity.AttachmentState)e.getValue()).items().size()) || ((AttachmentValueEntry)entry.getValue()).item.isEmpty() && ((AttachmentValueEntry)entry.getValue()).count.test(((PlaceableEdibleBlockEntity.AttachmentState)e.getValue()).items().size()) || !((AttachmentValueEntry)entry.getValue()).item.isEmpty() && ((AttachmentValueEntry)entry.getValue()).count.test((int)((AttachmentValueEntry)entry.getValue()).item.stream().flatMap(predicate -> ((PlaceableEdibleBlockEntity.AttachmentState)e.getValue()).items().stream().map(arg_0 -> ((ItemPredicate)predicate).test(arg_0))).count())).toList();
                if (list.isEmpty()) {
                    return !(!((AttachmentValueEntry)entry.getValue()).item.isEmpty() && !((AttachmentValueEntry)entry.getValue()).item.stream().allMatch(predicate -> predicate.test(ItemStack.EMPTY)) || !((AttachmentValueEntry)entry.getValue()).count.test(blockEntity.getAttachments().get(entry.getKey()).items().size()) || !((AttachmentValueEntry)entry.getValue()).active.isEmpty() && ((AttachmentValueEntry)entry.getValue()).active.get() != false);
                }
                return list.stream().allMatch(e -> ((AttachmentValueEntry)entry.getValue()).active.isEmpty() || ((PlaceableEdibleBlockEntity.AttachmentState)e.getValue()).active() == ((AttachmentValueEntry)entry.getValue()).active.get().booleanValue());
            }));
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof BlockValuesEntry)) {
                return false;
            }
            BlockValuesEntry entry = (BlockValuesEntry)obj;
            return entry.attachments.equals(this.attachments) && entry.biteCount.equals(this.biteCount);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.attachments, this.biteCount);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Optional<IntRange> biteCount = Optional.empty();
            private final Map<HolderSet<Item>, AttachmentValueEntry> attachments = new HashMap<HolderSet<Item>, AttachmentValueEntry>();

            public Builder exactBiteCount(int value) {
                this.biteCount = Optional.of(IntRange.exact(value));
                return this;
            }

            public Builder rangedBiteCount(int min, int max) {
                this.biteCount = Optional.of(IntRange.range(min, max));
                return this;
            }

            public Builder lowerBoundBiteCount(int min) {
                this.biteCount = Optional.of(IntRange.lowerBound(min));
                return this;
            }

            public Builder upperBoundBiteCount(int max) {
                this.biteCount = Optional.of(IntRange.upperBound(max));
                return this;
            }

            public Builder addAttachment(HolderSet<Item> items, AttachmentValueEntry.Builder builder) {
                this.attachments.put(items, builder.build());
                return this;
            }

            public BlockValuesEntry build() {
                return new BlockValuesEntry(this.biteCount, this.attachments);
            }
        }

        public record AttachmentValueEntry(List<ItemPredicate> item, IntRange count, Optional<Boolean> active) {
            public static final Codec<AttachmentValueEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemPredicate.CODEC.listOf().fieldOf("item").forGetter(AttachmentValueEntry::item), (App)IntRange.codec(0, 16).optionalFieldOf("count", (Object)IntRange.lowerBound(1)).forGetter(AttachmentValueEntry::count), (App)Codec.BOOL.optionalFieldOf("active").forGetter(AttachmentValueEntry::active)).apply((Applicative)inst, AttachmentValueEntry::new));

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof AttachmentValueEntry)) {
                    return false;
                }
                AttachmentValueEntry entry = (AttachmentValueEntry)obj;
                return entry.active.equals(this.active) && entry.count.equals(this.count) && entry.item.equals(this.item);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.item, this.count, this.active);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private final List<ItemPredicate> item = new ArrayList<ItemPredicate>();
                private IntRange count = IntRange.lowerBound(0);
                private Optional<Boolean> active = Optional.empty();

                public Builder item(ItemPredicate.Builder builder) {
                    this.item.add(builder.build());
                    return this;
                }

                public Builder exactCount(int value) {
                    this.count = IntRange.exact(value);
                    return this;
                }

                public Builder rangedCount(int min, int max) {
                    this.count = IntRange.range(min, max);
                    return this;
                }

                public Builder lowerBoundCount(int min) {
                    this.count = IntRange.lowerBound(min);
                    return this;
                }

                public Builder upperBoundCount(int max) {
                    this.count = IntRange.lowerBound(max);
                    return this;
                }

                public Builder active(boolean value) {
                    this.active = Optional.of(value);
                    return this;
                }

                public AttachmentValueEntry build() {
                    return new AttachmentValueEntry(this.item, this.count, this.active);
                }
            }
        }
    }

    public record ActivationEntry(Optional<Ingredient> ingredient, boolean setTo, Optional<SoundSettings> sound, Map<BlockValuesEntry, List<ParticleEntry>> particles, List<LootItemCondition> condition) {
        public static final Codec<ActivationEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Ingredient.CODEC.optionalFieldOf("ingredient").forGetter(ActivationEntry::ingredient), (App)Codec.BOOL.fieldOf("set_to").forGetter(ActivationEntry::setTo), (App)SoundSettings.CODEC.optionalFieldOf("sound").forGetter(ActivationEntry::sound), (App)PARTICLE_CODEC.listOf().optionalFieldOf("particles", List.of()).xmap(pairs -> pairs.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (object, object2) -> object, () -> new Object2ObjectLinkedOpenHashMap())), map -> map.entrySet().stream().map(entry -> Pair.of((Object)((BlockValuesEntry)entry.getKey()), (Object)((List)entry.getValue()))).collect(Collectors.toList())).forGetter(ActivationEntry::particles), (App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("condition", List.of()).forGetter(ActivationEntry::condition)).apply((Applicative)inst, ActivationEntry::new));

        public ActivationEntry(Ingredient ingredient, boolean setTo, Optional<SoundSettings> sound, Map<BlockValuesEntry, List<ParticleEntry>> particles, List<LootItemCondition> condition) {
            this(Optional.of(ingredient), setTo, sound, particles, condition);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ActivationEntry)) {
                return false;
            }
            ActivationEntry entry = (ActivationEntry)obj;
            return entry.condition.equals(this.condition) && entry.particles.equals(this.particles) && entry.sound.equals(this.sound) && entry.setTo == this.setTo && entry.ingredient == this.ingredient;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.ingredient, this.setTo, this.sound, this.particles, this.condition);
        }
    }

    public record SoundSettings(Holder<SoundEvent> sound, float chance, FloatRange volume, FloatRange pitch) {
        public static final Codec<SoundSettings> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SoundEvent.CODEC.fieldOf("sound").forGetter(SoundSettings::sound), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(SoundSettings::chance), (App)FloatRange.codec(0.0f, 2.0f).optionalFieldOf("volume", (Object)FloatRange.exact(1.0f)).forGetter(SoundSettings::volume), (App)FloatRange.codec(0.0f, 2.0f).optionalFieldOf("pitch", (Object)FloatRange.exact(1.0f)).forGetter(SoundSettings::pitch)).apply((Applicative)inst, SoundSettings::new));

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SoundSettings)) {
                return false;
            }
            SoundSettings entry = (SoundSettings)obj;
            return entry.pitch.equals(this.pitch) && entry.volume.equals(this.volume) && entry.sound == this.sound;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.sound, Float.valueOf(this.chance), this.volume, this.pitch);
        }
    }

    public record ParticleEntry(ParticleOptions particle, Vec3 position, Vec3 speed, float chance, Optional<SoundSettings> sound) {
        public static final Codec<ParticleEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ParticleTypes.CODEC.fieldOf("particle").forGetter(ParticleEntry::particle), (App)Vec3.CODEC.fieldOf("position").forGetter(ParticleEntry::position), (App)Vec3.CODEC.fieldOf("speed").forGetter(ParticleEntry::speed), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(ParticleEntry::chance), (App)SoundSettings.CODEC.optionalFieldOf("sound").forGetter(ParticleEntry::sound)).apply((Applicative)inst, ParticleEntry::new));
    }
}

