/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.api.variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.api.CowConfiguration;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.attachment.CowVariantAttachment;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public record OffspringConditions(List<LootItemCondition> thisConditions, List<LootItemCondition> otherConditions, Inheritance inheritance) {
    public static final Codec<OffspringConditions> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("this_conditions", List.of()).forGetter(OffspringConditions::thisConditions), (App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("other_conditions", List.of()).forGetter(OffspringConditions::otherConditions), (App)Inheritance.CODEC.optionalFieldOf("inheritance", (Object)Inheritance.PARENT).forGetter(OffspringConditions::inheritance)).apply((Applicative)inst, OffspringConditions::new));
    public static final Codec<OffspringConditions> CODEC = Codec.either((Codec)LootItemCondition.DIRECT_CODEC.listOf(), DIRECT_CODEC).flatComapMap(either -> (OffspringConditions)either.map(lootItemConditions -> new OffspringConditions((List<LootItemCondition>)lootItemConditions, List.of(), Inheritance.PARENT), Function.identity()), conditions -> {
        if (conditions.otherConditions.isEmpty()) {
            return DataResult.success((Object)Either.left(conditions.thisConditions));
        }
        return DataResult.success((Object)Either.right((Object)conditions));
    });
    public static final OffspringConditions EMPTY = new OffspringConditions(List.of(), List.of(), Inheritance.PARENT);

    public static enum Inheritance implements StringRepresentable
    {
        PARENT("parent_to_previous", (baby, parent, other) -> Inheritance.parentToPrevious(baby, parent)),
        OTHER("other_to_previous", (baby, parent, other) -> Inheritance.parentToPrevious(baby, other));

        public static final Codec<Inheritance> CODEC;
        private final String name;
        private final InheritanceOperation operation;

        private static Pair<Holder<CowVariant<?>>, Optional<Holder<CowVariant<?>>>> parentToPrevious(Holder<CowVariant<?>> baby, CowVariantAttachment parent) {
            if (parent.previousCowVariant().isPresent() && baby.is(parent.previousCowVariant().get())) {
                return Pair.of(baby, Optional.of(parent.cowVariant()));
            }
            return Pair.of(baby, parent.previousCowVariant());
        }

        private Inheritance(String name, InheritanceOperation operation) {
            this.name = name;
            this.operation = operation;
        }

        public <C extends CowConfiguration> Pair<Holder<CowVariant<C>>, Optional<Holder<CowVariant<C>>>> handleInheritance(Holder<CowVariant<C>> baby, CowVariantAttachment parent, CowVariantAttachment other) {
            return this.operation.handleInheritance(baby, parent, other);
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Inheritance::values);
        }
    }

    @FunctionalInterface
    private static interface InheritanceOperation {
        public Pair<Holder<CowVariant<?>>, Optional<Holder<CowVariant<?>>>> handleInheritance(Holder<CowVariant<?>> var1, CowVariantAttachment var2, CowVariantAttachment var3);
    }
}

