/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client;

import com.mojang.blaze3d.systems.RenderSystem;
import house.greenhouse.bovinesandbuttercups.api.attachment.LockdownAttachment;
import house.greenhouse.bovinesandbuttercups.content.attachment.BovinesAttachments;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;

public class LockdownClientEffectExtensions
implements IClientMobEffectExtensions {
    public static final LockdownClientEffectExtensions INSTANCE = new LockdownClientEffectExtensions();

    protected LockdownClientEffectExtensions() {
    }

    public boolean renderInventoryIcon(MobEffectInstance instance, AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
        List list = ((LockdownAttachment)Minecraft.getInstance().player.getData(BovinesAttachments.LOCKDOWN)).effects().entrySet().stream().toList();
        if (!list.isEmpty()) {
            int lockdownEffectIndex = Minecraft.getInstance().player.tickCount / (160 / list.size()) % list.size();
            Holder mobEffect1 = (Holder)((Map.Entry)list.get(lockdownEffectIndex)).getKey();
            TextureAtlasSprite additionalSprite = Minecraft.getInstance().getMobEffectTextures().get(mobEffect1);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)additionalSprite.atlasLocation());
            guiGraphics.blitSprite(RenderType::guiTextured, additionalSprite, x, y + 7, 18, 18);
        }
        return false;
    }

    public boolean renderGuiIcon(MobEffectInstance instance, Gui gui, GuiGraphics guiGraphics, int x, int y, float z, float alpha) {
        List list = ((LockdownAttachment)Minecraft.getInstance().player.getData(BovinesAttachments.LOCKDOWN)).effects().entrySet().stream().toList();
        if (!list.isEmpty()) {
            int lockdownEffectIndex = Minecraft.getInstance().player.tickCount / (160 / list.size()) % list.size();
            Holder statusEffect1 = (Holder)((Map.Entry)list.get(lockdownEffectIndex)).getKey();
            List<Map.Entry> runningOutEffectList = list.stream().filter(statusEffectIntegerEntry -> (Integer)statusEffectIntegerEntry.getValue() <= 200).toList();
            float a = alpha;
            if (list.size() > 1 && !runningOutEffectList.isEmpty()) {
                int runningOutEffectIndex = Minecraft.getInstance().player.tickCount / (160 / runningOutEffectList.size()) % runningOutEffectList.size();
                if (!instance.isAmbient()) {
                    int duration = (Integer)runningOutEffectList.get(runningOutEffectIndex).getValue();
                    int m = 10 - duration / 20;
                    a = Mth.clamp((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.cos((float)((float)duration * (float)Math.PI / 5.0f)) * Mth.clamp((float)((float)m / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                }
                statusEffect1 = (Holder)runningOutEffectList.get(runningOutEffectIndex).getKey();
            }
            TextureAtlasSprite additionalSprite = Minecraft.getInstance().getMobEffectTextures().get(statusEffect1);
            int argb = ARGB.white((float)a);
            guiGraphics.blitSprite(RenderType::guiTextured, additionalSprite, x + 3, y + 3, 18, 18, argb);
        }
        return false;
    }
}

