/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.api;

import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.attachment.CowVariantAttachment;
import house.greenhouse.bovinesandbuttercups.content.data.modifier.ConditionedTextureModifierFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class RenderStateObject {
    private static final Map<Type<Object>, Function<Entity, Object>> GLOBAL_REGISTRY = new HashMap<Type<Object>, Function<Entity, Object>>();
    public static final Type<List<ResourceLocation>> ACTIVE_CONDITIONS = new Type<List>(BovinesAndButtercups.asResource("active_conditions"), List.class);
    public static final Type<BlockPos> BLOCK_POS = new Type<BlockPos>(BovinesAndButtercups.asResource("block_pos"), BlockPos.class);

    public static void registerAll() {
        RenderStateObject.registerGlobalRenderStateObject(ACTIVE_CONDITIONS, entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                CowVariantAttachment attachment = BovinesAndButtercups.getHelper().getCowVariantAttachment(living);
                if (attachment == null) {
                    return List.of();
                }
                return ((CowVariant)attachment.cowVariant().value()).configuration().layers().stream().flatMap(cowModelLayer -> cowModelLayer.textureModifiers().stream().map(textureModifierFactory -> {
                    ConditionedTextureModifierFactory conditioned;
                    if (textureModifierFactory instanceof ConditionedTextureModifierFactory && (conditioned = (ConditionedTextureModifierFactory)textureModifierFactory).getConditionValue((Entity)entity)) {
                        return conditioned.getConditionId();
                    }
                    return null;
                }).filter(Objects::nonNull)).toList();
            }
            return List.of();
        });
        RenderStateObject.registerGlobalRenderStateObject(BLOCK_POS, Entity::blockPosition);
    }

    public static <T> void registerGlobalRenderStateObject(Type<T> type, Function<Entity, T> function) {
        if (GLOBAL_REGISTRY.containsKey(type)) {
            throw new UnsupportedOperationException("Cannot register type '" + String.valueOf(type.id()) + "' twice.");
        }
        GLOBAL_REGISTRY.put(type, function);
    }

    public static void setupGlobalObjects(Map<Type<Object>, Object> toModify, Entity entity) {
        for (Map.Entry<Type<Object>, Function<Entity, Object>> registryValue : GLOBAL_REGISTRY.entrySet()) {
            toModify.put(registryValue.getKey(), registryValue.getValue().apply(entity));
        }
    }

    public record Type<T>(ResourceLocation id, Class<T> type) {
    }
}

