/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.api.model;

import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.client.BovinesAndButtercupsClient;
import house.greenhouse.bovinesandbuttercups.client.api.model.type.BovinesModelSetType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BovinesModelSet {
    private final BovinesModelSetType type;
    private final Map<ResourceLocation, ResourceLocation> modelMap;
    private final ResourceLocation id;
    private final Map<Object, ResourceLocation> lookup;
    private final Set<ResourceLocation> warnedKeys = new HashSet<ResourceLocation>();

    public BovinesModelSet(ResourceLocation id, BovinesModelSetType type, Map<ResourceLocation, ResourceLocation> modelMap, Map<Object, ResourceLocation> lookup) {
        this.id = id;
        this.type = type;
        this.modelMap = modelMap;
        this.lookup = lookup;
    }

    public BakedModel getModel() {
        return this.getModel(this.id);
    }

    public BakedModel getModel(Object lookupObj) {
        return this.getModel(lookupObj, null, () -> "Bovines Model Set \"" + String.valueOf(this.id) + "\" could not find model from object: " + String.valueOf(lookupObj));
    }

    public BakedModel getModel(ResourceLocation modelId) {
        return this.getModel(modelId, (ResourceLocation)null, () -> "Bovines Model Set \"" + String.valueOf(this.id) + "\" does not contain model with path \"" + String.valueOf(modelId) + "\"");
    }

    public BakedModel getModel(Object lookupObj, @Nullable ResourceLocation fallback, Supplier<String> errorMessage) {
        return this.getModel(this.lookup.get(lookupObj), fallback, errorMessage);
    }

    public BakedModel getModel(ResourceLocation modelId, @Nullable ResourceLocation fallback, @Nullable Supplier<String> errorMessage) {
        if (!this.modelMap.containsKey(modelId)) {
            BakedModel fallbackModel;
            if (fallback != null && (fallbackModel = this.getModel(fallback, (ResourceLocation)null, (Supplier<String>)null)) != null) {
                return fallbackModel;
            }
            if (!this.warnedKeys.contains(modelId) && errorMessage != null) {
                BovinesAndButtercups.LOG.warn(errorMessage.get());
                this.warnedKeys.add(modelId);
            }
            return Minecraft.getInstance().getModelManager().getMissingModel();
        }
        return BovinesAndButtercupsClient.getHelper().getModel(this.modelMap.get(modelId));
    }

    public List<Object> lookupKeys() {
        return List.copyOf(this.lookup.keySet());
    }

    public List<ResourceLocation> resolvedModelPaths() {
        return List.copyOf(this.modelMap.values());
    }

    public BovinesModelSetType type() {
        return this.type;
    }

    public ResourceLocation id() {
        return this.id;
    }
}

