/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.api.model.condition;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Keyable;
import house.greenhouse.bovinesandbuttercups.client.api.model.condition.AndCondition;
import house.greenhouse.bovinesandbuttercups.client.api.model.condition.OrCondition;
import house.greenhouse.bovinesandbuttercups.client.api.model.condition.PlaceableEdibleCondition;
import house.greenhouse.bovinesandbuttercups.client.api.model.condition.ValueCondition;
import house.greenhouse.bovinesandbuttercups.client.util.BovinesModelSetUtil;
import house.greenhouse.bovinesandbuttercups.content.block.entity.PlaceableEdibleBlockEntity;
import house.greenhouse.bovinesandbuttercups.util.IntRange;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;

public record PlaceableEdibleSelector(PlaceableEdibleCondition condition, MultiVariant variant) {
    public PlaceableEdibleSelector {
        if (condition == null) {
            throw new IllegalArgumentException("Missing condition for selector");
        }
        if (variant == null) {
            throw new IllegalArgumentException("Missing variant for selector");
        }
    }

    public boolean test(PlaceableEdibleBlockEntity blockEntity) {
        return this.condition.test(blockEntity);
    }

    public static class Deserializer
    implements JsonDeserializer<PlaceableEdibleSelector> {
        public PlaceableEdibleSelector deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = json.getAsJsonObject();
            return new PlaceableEdibleSelector(this.getSelector(jsonobject), (MultiVariant)context.deserialize(jsonobject.get("apply"), MultiVariant.class));
        }

        private PlaceableEdibleCondition getSelector(JsonObject json) {
            return json.has("when") ? Deserializer.getCondition(json.get("when")) : PlaceableEdibleCondition.TRUE;
        }

        static PlaceableEdibleCondition getCondition(JsonElement json) {
            if (json.isJsonObject()) {
                JsonObject jo = json.getAsJsonObject();
                Set set = jo.entrySet();
                if (set.isEmpty()) {
                    throw new JsonParseException("No elements found in selector");
                }
                if (jo.has("OR")) {
                    List<PlaceableEdibleCondition> list1 = Streams.stream((Iterable)GsonHelper.getAsJsonArray((JsonObject)jo, (String)"OR")).map(p_112038_ -> Deserializer.getCondition((JsonElement)p_112038_.getAsJsonObject())).collect(Collectors.toList());
                    return new OrCondition(list1);
                }
                if (jo.has("AND")) {
                    List<PlaceableEdibleCondition> list = Streams.stream((Iterable)GsonHelper.getAsJsonArray((JsonObject)jo, (String)"AND")).map(p_112028_ -> Deserializer.getCondition((JsonElement)p_112028_.getAsJsonObject())).collect(Collectors.toList());
                    return new AndCondition(list);
                }
                return Deserializer.getValueCondition(jo);
            }
            if (json.isJsonArray()) {
                JsonArray ja = json.getAsJsonArray();
                if (ja.isEmpty()) {
                    throw new JsonParseException("No elements found in selector");
                }
                List<PlaceableEdibleCondition> list = Streams.stream((Iterable)ja).map(p_112028_ -> Deserializer.getCondition((JsonElement)p_112028_.getAsJsonObject())).collect(Collectors.toList());
                return new AndCondition(list);
            }
            throw new JsonParseException("Selector must be either an array of conditions, or a condition object, prefixed with \"AND\" or \"OR\" if necessary");
        }

        static PlaceableEdibleCondition getValueCondition(JsonObject json) {
            Optional<IntRange> bites = Optional.empty();
            if (json.has("bites")) {
                bites = Optional.of((IntRange)((Pair)IntRange.codec(1, 16).decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get("bites")).getOrThrow(JsonParseException::new)).getFirst());
            }
            Map attachments = Map.of();
            if (json.has("attachments")) {
                attachments = (Map)((Pair)Codec.simpleMap((Codec)Codec.either((Codec)TagKey.hashedCodec((ResourceKey)Registries.ITEM), (Codec)Codec.either((Codec)ResourceKey.codec((ResourceKey)Registries.ITEM).listOf(), (Codec)ResourceKey.codec((ResourceKey)Registries.ITEM)).xmap(either -> (List)either.map(resourceKeys -> resourceKeys, List::of), resourceKeys -> {
                    if (resourceKeys.size() == 1) {
                        return Either.right((Object)((ResourceKey)resourceKeys.getFirst()));
                    }
                    return Either.left((Object)resourceKeys);
                })), ValueCondition.AttachmentValues.CODEC, (Keyable)Keyable.forStrings(() -> Stream.of("items", "values"))).codec().decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryOps.RegistryInfoLookup)BovinesModelSetUtil.STARTUP_LOOKUP), (Object)json.getAsJsonObject("attachments")).getOrThrow(JsonParseException::new)).getFirst();
            }
            return new ValueCondition(bites, attachments);
        }
    }
}

