/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.api.model.type;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.client.api.model.BovinesModelSet;
import house.greenhouse.bovinesandbuttercups.client.api.model.type.BovinesModelSetType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.block.model.UnbakedBlockStateModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;

public class StateDefinitionBovinesModelSetType
implements BovinesModelSetType {
    private static final Map<ResourceLocation, UnbakedBlockStateModel> LOADED = new HashMap<ResourceLocation, UnbakedBlockStateModel>();
    private final StateDefinition<Block, BlockState> definition;

    public StateDefinitionBovinesModelSetType(StateDefinition<Block, BlockState> definition) {
        this.definition = definition;
    }

    public static BakedModel getBlockModel(BovinesModelSet modelSet, BlockState state) {
        if (modelSet == null) {
            return Minecraft.getInstance().getModelManager().getMissingModel();
        }
        return modelSet.getModel(BlockModelShaper.stateToModelLocation((BlockState)state).getVariant(), null, () -> "Could not get blockstate bovines model set for block \"" + String.valueOf(((ResourceKey)state.getBlockHolder().unwrapKey().orElseThrow()).location()) + "\" and for type \"" + String.valueOf(modelSet.id()) + "\" with properties \"" + StateDefinitionBovinesModelSetType.acceptedProperties(BlockModelShaper.stateToModelLocation((BlockState)state).getVariant()) + "\".");
    }

    @Override
    public BovinesModelSet createReference(ResourceLocation fileId, JsonObject json) {
        HashMap<ResourceLocation, ResourceLocation> modelIds = new HashMap<ResourceLocation, ResourceLocation>();
        HashMap<Object, ResourceLocation> lookup = new HashMap<Object, ResourceLocation>();
        Map def = BlockModelDefinition.fromJsonElement((JsonElement)json).instantiate(this.definition, fileId.toString());
        for (Map.Entry state : def.entrySet()) {
            ResourceLocation stateResource = fileId.withPath(s -> s + "/" + StateDefinitionBovinesModelSetType.acceptedProperties(BlockModelShaper.statePropertiesToString((Map)((BlockState)state.getKey()).getValues())));
            ResourceLocation resolvedResource = stateResource.withPath(s -> "bovinesandbuttercups/" + s);
            modelIds.put(stateResource, resolvedResource);
            lookup.put(BlockModelShaper.stateToModelLocation((BlockState)((BlockState)state.getKey())).getVariant(), stateResource);
            LOADED.put(resolvedResource, (UnbakedBlockStateModel)state.getValue());
        }
        return new BovinesModelSet(fileId, this, modelIds, lookup);
    }

    @Override
    public UnbakedModel createUnbaked(ResourceLocation modelId) {
        final UnbakedBlockStateModel model = LOADED.get(modelId);
        LOADED.remove(modelId);
        if (model == null || this.definition == null) {
            BovinesAndButtercups.LOG.warn("Failed to load model {} defaulting to missing model.", (Object)modelId);
            return MissingBlockModel.missingModel();
        }
        return new UnbakedModel(){

            public BakedModel bake(TextureSlots textureSlots, ModelBaker baker, ModelState modelState, boolean hasAmbientOcclusion, boolean useBlockLight, ItemTransforms transforms) {
                return model.bake(baker);
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
                model.resolveDependencies(resolver);
            }
        };
    }

    private static String acceptedProperties(String stateProperties) {
        return stateProperties.replaceAll("=", ".").replaceAll(",", "-");
    }
}

