/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.model;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import house.greenhouse.bovinesandbuttercups.client.api.model.condition.PlaceableEdibleSelector;
import house.greenhouse.bovinesandbuttercups.content.block.entity.PlaceableEdibleBlockEntity;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class PlaceableEdibleMultiPartBakedModel
implements BakedModel {
    private final List<Pair<PlaceableEdibleSelector, BakedModel>> selectors;
    protected final boolean hasAmbientOcclusion;
    protected final boolean isGui3d;
    protected final boolean usesBlockLight;
    protected final TextureAtlasSprite particleIcon;
    protected final ItemTransforms transforms;
    private final Map<PlaceableEdibleBlockEntity.EdibleBlockEntityValues, BitSet> selectorCache = new Reference2ObjectOpenHashMap();
    private static final ModelProperty<BitSet> BIT_SET_PROPERTY = new ModelProperty();

    public PlaceableEdibleMultiPartBakedModel(List<Pair<PlaceableEdibleSelector, BakedModel>> selectors) {
        this.selectors = selectors;
        BakedModel model = (BakedModel)selectors.iterator().next().getSecond();
        this.hasAmbientOcclusion = model.useAmbientOcclusion();
        this.isGui3d = model.isGui3d();
        this.usesBlockLight = model.usesBlockLight();
        this.particleIcon = model.getParticleIcon();
        this.transforms = model.getTransforms();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random, ModelData data, @Nullable RenderType renderType) {
        if (state == null) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        long k = random.nextLong();
        if (!data.has(BIT_SET_PROPERTY)) {
            return Collections.emptyList();
        }
        for (int j = 0; j < ((BitSet)data.get(BIT_SET_PROPERTY)).length(); ++j) {
            if (!((BitSet)data.get(BIT_SET_PROPERTY)).get(j)) continue;
            list.addAll(((BakedModel)this.selectors.get(j).getSecond()).getQuads(state, direction, RandomSource.create((long)k), data, renderType));
        }
        return list;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PlaceableEdibleBlockEntity) {
            PlaceableEdibleBlockEntity placeableEdibleBlockEntity = (PlaceableEdibleBlockEntity)blockEntity;
            PlaceableEdibleBlockEntity.EdibleBlockEntityValues values = PlaceableEdibleBlockEntity.EdibleBlockEntityValues.fromBlockEntity(placeableEdibleBlockEntity);
            BitSet bitset = this.selectorCache.get(values);
            if (bitset == null) {
                bitset = new BitSet();
                for (int i = 0; i < this.selectors.size(); ++i) {
                    Pair<PlaceableEdibleSelector, BakedModel> pair = this.selectors.get(i);
                    if (!((PlaceableEdibleSelector)pair.getFirst()).test(placeableEdibleBlockEntity)) continue;
                    bitset.set(i);
                }
                this.selectorCache.put(values, bitset);
            }
            return modelData.derive().with(BIT_SET_PROPERTY, (Object)bitset).build();
        }
        return modelData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction direction, RandomSource randomSource) {
        return Collections.emptyList();
    }

    public boolean useAmbientOcclusion() {
        return this.hasAmbientOcclusion;
    }

    public boolean isGui3d() {
        return this.isGui3d;
    }

    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return this.particleIcon;
    }

    @Deprecated
    public TextureAtlasSprite getParticleIcon() {
        return null;
    }

    public ItemTransforms getTransforms() {
        return this.transforms;
    }
}

