/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.particle;

import house.greenhouse.bovinesandbuttercups.content.particle.ModelLocationParticleOptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;

public class ModelLocationParticle
extends TextureSheetParticle {
    private final BlockPos pos;
    private final float uo;
    private final float vo;

    public ModelLocationParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ResourceLocation location, String variant) {
        this(level, x, y, z, xSpeed, ySpeed, zSpeed, location, variant, new BlockPos((int)x, (int)y, (int)z));
    }

    public ModelLocationParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ResourceLocation location, String variant, BlockPos pos) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.pos = pos;
        this.setSprite(Minecraft.getInstance().getModelManager().getModel(new ModelResourceLocation(location, variant)).getParticleIcon());
        this.gravity = 1.0f;
        this.rCol = 0.6f;
        this.gCol = 0.6f;
        this.bCol = 0.6f;
        this.quadSize /= 2.0f;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f * 16.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f * 16.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f * 16.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f * 16.0f);
    }

    public int getLightColor(float p_108291_) {
        int i = super.getLightColor(p_108291_);
        return i == 0 && this.level.hasChunkAt(this.pos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)this.pos) : i;
    }

    public static class Provider
    implements ParticleProvider<ModelLocationParticleOptions> {
        public Particle createParticle(ModelLocationParticleOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ResourceLocation modelKey = type.modelKey();
            String variant = type.modelVariant();
            return new ModelLocationParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, modelKey, variant);
        }
    }
}

