/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.renderer.entity;

import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.layer.CowLayersLayer;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.layer.MoobloomFlowerLayer;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.model.MoobloomModel;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.model.state.MoobloomRenderState;
import house.greenhouse.bovinesandbuttercups.client.util.BovinesModelLayers;
import house.greenhouse.bovinesandbuttercups.content.entity.Moobloom;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MoobloomRenderer
extends AgeableMobRenderer<Moobloom, MoobloomRenderState, MoobloomModel> {
    private final Function<ModelLayerLocation, ModelPart> bakeLayerFunction;

    public MoobloomRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MoobloomModel(context.bakeLayer(BovinesModelLayers.MOOBLOOM_MODEL_LAYER)), (EntityModel)new MoobloomModel(context.bakeLayer(BovinesModelLayers.BABY_MOOBLOOM_MODEL_LAYER)), 0.7f);
        this.addLayer(new CowLayersLayer(this));
        this.addLayer(new MoobloomFlowerLayer((RenderLayerParent<MoobloomRenderState, MoobloomModel>)this, context.getBlockRenderDispatcher()));
        this.bakeLayerFunction = arg_0 -> ((EntityRendererProvider.Context)context).bakeLayer(arg_0);
    }

    public ResourceLocation getTextureLocation(MoobloomRenderState entity) {
        return BovinesAndButtercups.asResource("textures/entity/bovinesandbuttercups/moobloom/missing_moobloom.png");
    }

    public MoobloomRenderState createRenderState() {
        return new MoobloomRenderState(modelLayerLocation -> new MoobloomModel(this.bakeLayerFunction.apply((ModelLayerLocation)modelLayerLocation)));
    }

    public void extractRenderState(Moobloom moobloom, MoobloomRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)moobloom, (LivingEntityRenderState)state, partialTicks);
        state.extractDefaultRenderStates(moobloom);
        state.extractModel(this, moobloom);
        state.getUpAnimationState.copyFrom(moobloom.getUpAnimationState);
        state.layDownAnimationState.copyFrom(moobloom.layDownAnimationState);
    }
}

