/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.renderer.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import house.greenhouse.bovinesandbuttercups.api.CowConfiguration;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.variant.CowModelLayer;
import house.greenhouse.bovinesandbuttercups.api.variant.modifier.TextureModifierFactory;
import house.greenhouse.bovinesandbuttercups.client.api.CowVariantRenderState;
import java.util.Comparator;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;

public class CowLayersLayer<C extends CowConfiguration, T extends LivingEntityRenderState, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public CowLayersLayer(RenderLayerParent<T, M> context) {
        super(context);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T renderState, float yRot, float xRot) {
        Holder attachment = ((CowVariantRenderState)renderState).getCowVariant();
        if (((LivingEntityRenderState)renderState).isInvisible || attachment == null || !((CowVariantRenderState)renderState).getCowVariant().isBound() || ((CowVariant)attachment.value()).configuration().layers().isEmpty()) {
            return;
        }
        block0: for (CowModelLayer cowLayer : ((CowVariant)attachment.value()).configuration().layers()) {
            ResourceLocation mappedTextureLocation = cowLayer.textureLocation().withPath(string -> "textures/entity/" + string + ".png");
            RenderType renderType = RenderType.entityTranslucent((ResourceLocation)mappedTextureLocation);
            int color = -1;
            for (TextureModifierFactory factory : cowLayer.textureModifiers().stream().sorted(Comparator.comparingInt(TextureModifierFactory::priority)).toList()) {
                Object provider = factory.getOrCreateProvider();
                if (!provider.canDisplay((CowVariantRenderState)renderState)) continue block0;
                color = provider.color((CowVariantRenderState)renderState, color);
                renderType = provider.renderType(mappedTextureLocation, renderType);
            }
            this.getParentModel().renderToBuffer(poseStack, bufferSource.getBuffer(renderType), packedLight, LivingEntityRenderer.getOverlayCoords(renderState, (float)0.0f), color);
        }
    }
}

