/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.client.BovinesAndButtercupsClient;
import house.greenhouse.bovinesandbuttercups.content.component.BovinesDataComponents;
import house.greenhouse.bovinesandbuttercups.content.component.FlowerCrown;
import house.greenhouse.bovinesandbuttercups.content.data.flowercrown.FlowerCrownMaterial;
import house.greenhouse.bovinesandbuttercups.mixin.client.ModelBakeryModelBakerImplInvoker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FlowerCrownItemRenderer
implements SpecialModelRenderer<FlowerCrown> {
    private static final Map<FlowerCrown, TextureMap> FLOWER_CROWN_TO_TEXTURE_MAP = new HashMap<FlowerCrown, TextureMap>();
    private static final Map<TextureMap, BakedModel> MODEL_MAP = new HashMap<TextureMap, BakedModel>();
    public static final ResourceLocation BASE = BovinesAndButtercups.asResource("item/base_flower_crown");
    public static final FlowerCrownItemRenderer INSTANCE = new FlowerCrownItemRenderer();

    public static void clearModelMap() {
        MODEL_MAP.clear();
    }

    protected FlowerCrownItemRenderer() {
    }

    public void render(@Nullable FlowerCrown flowerCrown, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        BakedModel model = flowerCrown == null ? BovinesAndButtercupsClient.getHelper().getModel(BASE) : MODEL_MAP.computeIfAbsent(FLOWER_CROWN_TO_TEXTURE_MAP.computeIfAbsent(flowerCrown, TextureMap::new), FlowerCrownItemRenderer::createModel);
        ItemRenderer.renderItem((ItemDisplayContext)displayContext, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (int)packedOverlay, (int[])new int[0], (BakedModel)model, (RenderType)RenderType.cutout(), (ItemStackRenderState.FoilType)ItemStackRenderState.FoilType.NONE);
    }

    @Nullable
    public FlowerCrown extractArgument(ItemStack stack) {
        return (FlowerCrown)stack.get(BovinesDataComponents.FLOWER_CROWN);
    }

    private static BakedModel createModel(TextureMap component) {
        HashMap<String, TextureSlots.Value> textureMap = new HashMap<String, TextureSlots.Value>();
        textureMap.put("particle", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.top())));
        textureMap.put("layer0", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.centerLeft())));
        textureMap.put("layer1", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.centerRight())));
        textureMap.put("layer2", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.topLeft())));
        textureMap.put("layer3", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.topRight())));
        textureMap.put("layer4", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.top())));
        textureMap.put("top_left", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.topLeft())));
        textureMap.put("top", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.top())));
        textureMap.put("top_right", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.topRight())));
        textureMap.put("center_left", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.centerLeft())));
        textureMap.put("center_right", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.centerRight())));
        textureMap.put("bottom_left", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.bottomLeft())));
        textureMap.put("bottom", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.bottom())));
        textureMap.put("bottom_right", new TextureSlots.Value(new Material(TextureAtlas.LOCATION_BLOCKS, component.bottomRight())));
        String textureString = "top_left=" + String.valueOf(component.topLeft()) + ",top=" + String.valueOf(component.top()) + ",top_right=" + String.valueOf(component.topRight()) + ",center_left=" + String.valueOf(component.centerLeft()) + ",center_right=" + String.valueOf(component.centerRight()) + ",bottom_left=" + String.valueOf(component.bottomLeft()) + ",bottom=" + String.valueOf(component.bottom()) + ",bottom_right=" + String.valueOf(component.bottomRight());
        BlockModel blockModel = new BlockModel(BASE, List.of(), new TextureSlots.Data(textureMap), Boolean.valueOf(true), UnbakedModel.GuiLight.FRONT, BovinesAndButtercupsClient.getHelper().getModel(BASE).getTransforms());
        ModelBakery modelBakery = BovinesAndButtercupsClient.getHelper().getModelBakery();
        Objects.requireNonNull(modelBakery);
        ModelBakery.ModelBakerImpl impl = new ModelBakery.ModelBakerImpl(modelBakery, new ModelBakery.TextureGetter(){

            public TextureAtlasSprite get(ModelDebugName debugName, Material material) {
                TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(material.atlasLocation()).getSprite(material.texture());
                if (sprite.atlasLocation() == MissingTextureAtlasSprite.getLocation()) {
                    this.reportMissingReference(debugName, material.toString());
                }
                return sprite;
            }

            public TextureAtlasSprite reportMissingReference(ModelDebugName debugName, String material) {
                return Minecraft.getInstance().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS).getSprite(MissingTextureAtlasSprite.getLocation());
            }
        }, () -> new ModelResourceLocation(BovinesAndButtercups.asResource("item/custom_flower_crown"), textureString).toString());
        blockModel.resolveDependencies(model -> ((ModelBakeryModelBakerImplInvoker)impl).bovinesandbuttercups$getModel(model));
        return UnbakedModel.bakeWithTopModelValues((UnbakedModel)blockModel, (ModelBaker)impl, (ModelState)BlockModelRotation.X0_Y0);
    }

    protected record TextureMap(ResourceLocation topLeft, ResourceLocation top, ResourceLocation topRight, ResourceLocation centerLeft, ResourceLocation centerRight, ResourceLocation bottomLeft, ResourceLocation bottom, ResourceLocation bottomRight) {
        private TextureMap(FlowerCrown component) {
            this(((FlowerCrownMaterial)component.topLeft().value()).itemTextures().topLeft(), ((FlowerCrownMaterial)component.top().value()).itemTextures().top(), ((FlowerCrownMaterial)component.topRight().value()).itemTextures().topRight(), ((FlowerCrownMaterial)component.centerLeft().value()).itemTextures().centerLeft(), ((FlowerCrownMaterial)component.centerRight().value()).itemTextures().centerRight(), ((FlowerCrownMaterial)component.bottomLeft().value()).itemTextures().bottomLeft(), ((FlowerCrownMaterial)component.bottom().value()).itemTextures().bottom(), ((FlowerCrownMaterial)component.bottomRight().value()).itemTextures().bottomRight());
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof TextureMap)) {
                return false;
            }
            TextureMap textureMap = (TextureMap)other;
            return textureMap.topLeft.equals((Object)this.topLeft) && textureMap.top.equals((Object)this.top) && textureMap.topRight.equals((Object)this.topRight) && textureMap.centerLeft.equals((Object)this.centerLeft) && textureMap.centerRight.equals((Object)this.centerRight) && textureMap.bottomLeft.equals((Object)this.bottomLeft) && textureMap.bottom.equals((Object)this.bottom) && textureMap.bottomRight.equals((Object)this.bottomRight);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.topLeft, this.top, this.topRight, this.centerLeft, this.centerRight, this.bottomLeft, this.bottom, this.bottomRight);
        }
    }

    public static class Unbaked
    implements SpecialModelRenderer.Unbaked {
        public static final ResourceLocation ID = BovinesAndButtercups.asResource("flower_crown");
        public static final Unbaked INSTANCE = new Unbaked();
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        protected Unbaked() {
        }

        @Nullable
        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return INSTANCE;
        }

        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

